/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinRecursiveElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public abstract class AbstractCucumberJavaExtension
extends AbstractCucumberExtension {
    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension", "isStepLikeFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension", "isStepLikeFile"));
        }
        return child instanceof PsiClassOwner;
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        VirtualFile vFile;
        PsiFile file;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension", "isWritableStepLikeFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension", "isWritableStepLikeFile"));
        }
        if (child instanceof PsiClassOwner && (file = child.getContainingFile()) != null && (vFile = file.getVirtualFile()) != null) {
            VirtualFile rootForFile = ProjectRootManager.getInstance((Project)child.getProject()).getFileIndex().getSourceRootForFile(vFile);
            return rootForFile != null;
        }
        return false;
    }

    @NotNull
    public Collection<String> getGlues(@NotNull GherkinFile file, Set<String> gluesFromOtherFiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension", "getGlues"));
        }
        if (gluesFromOtherFiles == null) {
            gluesFromOtherFiles = ContainerUtil.newHashSet();
        }
        final HashSet glues = gluesFromOtherFiles;
        file.accept((PsiElementVisitor)new GherkinRecursiveElementVisitor(){

            public void visitStep(GherkinStep step) {
                String glue = CucumberJavaUtil.getPackageOfStep(step);
                if (glue != null) {
                    CucumberJavaUtil.addGlue(glue, glues);
                }
            }
        });
        HashSet hashSet = glues;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension", "getGlues"));
        }
        return hashSet;
    }

    public Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension", "getStepDefinitionContainers"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile);
        if (module == null) {
            return Collections.emptySet();
        }
        List stepDefs = this.loadStepsFor((PsiFile)featureFile, module);
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        for (AbstractStepDefinition stepDef : stepDefs) {
            PsiFile psiFile;
            PsiElement stepDefElement = stepDef.getElement();
            if (stepDefElement == null || !this.isWritableStepLikeFile((PsiElement)(psiFile = stepDefElement.getContainingFile()), (PsiElement)psiFile.getParent())) continue;
            result.add(psiFile);
        }
        return result;
    }
}

