/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfigurationProducer;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;

public class CucumberJavaAllFeaturesInFolderRunConfigurationProducer
extends CucumberJavaRunConfigurationProducer {
    @Override
    protected NullableComputable<String> getStepsGlue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaAllFeaturesInFolderRunConfigurationProducer", "getStepsGlue"));
        }
        final Set<String> glues = this.getHookGlue(element);
        if (element instanceof PsiDirectory) {
            final PsiDirectory dir = (PsiDirectory)element;
            final CucumberJvmExtensionPoint[] extensions = (CucumberJvmExtensionPoint[])Extensions.getExtensions((ExtensionPointName)CucumberJvmExtensionPoint.EP_NAME);
            return new NullableComputable<String>(){

                @Nullable
                public String compute() {
                    dir.accept(new PsiElementVisitor(){

                        public void visitFile(PsiFile file) {
                            if (file instanceof GherkinFile) {
                                for (CucumberJvmExtensionPoint extension : extensions) {
                                    extension.getGlues((GherkinFile)file, glues);
                                }
                            }
                        }

                        public void visitDirectory(PsiDirectory dir) {
                            for (PsiDirectory psiDirectory : dir.getSubdirectories()) {
                                psiDirectory.accept((PsiElementVisitor)this);
                            }
                            for (PsiDirectory psiDirectory : dir.getFiles()) {
                                psiDirectory.accept((PsiElementVisitor)this);
                            }
                        }
                    });
                    return StringUtil.join((Collection)glues, (String)" ");
                }
            };
        }
        return null;
    }

    @Override
    protected String getConfigurationName(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaAllFeaturesInFolderRunConfigurationProducer", "getConfigurationName"));
        }
        PsiElement element = context.getPsiLocation();
        return CucumberBundle.message((String)"cucumber.run.all.features", (Object[])new Object[]{((PsiDirectory)element).getVirtualFile().getName()});
    }

    @Override
    @Nullable
    protected VirtualFile getFileToRun(ConfigurationContext context) {
        PsiElement element = context.getPsiLocation();
        if (element != null && element instanceof PsiDirectory) {
            return ((PsiDirectory)element).getVirtualFile();
        }
        return null;
    }
}

