/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.references.controller.ActionReference;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;

public class GrailsCreateActionByUsageIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Create action" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/actions/GrailsCreateActionByUsageIntention", "getText"));
        }
        return "Create action";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/actions/GrailsCreateActionByUsageIntention", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    public static Pair<GrClassDefinition, String> getData(Editor editor, PsiFile file) {
        if (!(file instanceof GroovyFile) && !(file instanceof GspFile)) {
            return null;
        }
        PsiReference ref = file.findReferenceAt(editor.getCaretModel().getOffset());
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference : ((PsiMultiReference)ref).getReferences()) {
                if (!(reference instanceof ActionReference)) continue;
                ref = reference;
                break;
            }
        }
        if (!(ref instanceof ActionReference)) {
            return null;
        }
        if (ref.resolve() != null) {
            return null;
        }
        String controllerName = ((ActionReference)ref).getControllerName();
        if (controllerName == null) {
            return null;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        Collection<GrClassDefinition> instances = GrailsArtifact.CONTROLLER.getInstances(module, controllerName);
        if (instances.isEmpty()) {
            return null;
        }
        String actionName = ((ActionReference)ref).getValue();
        if (!GroovyNamesUtil.isIdentifier((String)actionName)) {
            return null;
        }
        return Pair.create((Object)instances.iterator().next(), (Object)actionName);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/actions/GrailsCreateActionByUsageIntention", "isAvailable"));
        }
        Pair<GrClassDefinition, String> pair = GrailsCreateActionByUsageIntention.getData(editor, file);
        return pair != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/actions/GrailsCreateActionByUsageIntention", "invoke"));
        }
        Pair<GrClassDefinition, String> pair = GrailsCreateActionByUsageIntention.getData(editor, file);
        if (pair == null) {
            return;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        Map<String, PsiMethod> actions = GrailsUtils.getControllerActions(Collections.singletonList(pair.first), module);
        PsiMethod lastActionMethod = (PsiMethod)ContainerUtil.iterateAndGetLastItem(actions.values());
        boolean actionAsClosure = lastActionMethod instanceof GrAccessorMethod || !GrailsStructure.isAtLeastGrails1_4(module);
        Object action = actionAsClosure ? GroovyPsiElementFactory.getInstance((Project)project).createFieldDeclarationFromText("def " + (String)pair.second + " = {}") : GroovyPsiElementFactory.getInstance((Project)project).createMethodFromText((CharSequence)("def " + (String)pair.second + "() {}"));
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)((PsiElement)pair.first))) {
            return;
        }
        if (lastActionMethod == null) {
            action = (GrMembersDeclaration)((GrClassDefinition)pair.first).addBefore((PsiElement)action, null);
        } else {
            PsiMethod anchor = lastActionMethod;
            if (anchor instanceof GrAccessorMethod) {
                anchor = ((GrAccessorMethod)anchor).getProperty().getParent();
            }
            action = (GrMembersDeclaration)((GrClassDefinition)pair.first).addAfter((PsiElement)action, (PsiElement)anchor);
        }
        action = (GrMembersDeclaration)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)action);
        Object block = actionAsClosure ? (GrClosableBlock)action.getVariables()[0].getInitializerGroovy() : ((GrMethod)action).getBlock();
        ((Navigatable)block.getLastChild()).navigate(true);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

