/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor.toolbar;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.LocalFileSystem;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.actions.ArtefactData;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.editor.toolbar.GenerateActionBase;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/grails/editor/toolbar/GenerateActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "command", "", "text", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getCommand", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "data", "Lorg/jetbrains/plugins/grails/actions/ArtefactData;", "onDone", "update", "groovy-mvc"})
public abstract class GenerateActionBase
extends AnAction {
    @NotNull
    private final String command;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        presentation.setEnabledAndVisible(this.isEnabled(dataContext));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        ArtefactData artefactData = GrailsActionUtilKt.getArtefactData(e.getDataContext());
        if (artefactData == null) {
            return;
        }
        ArtefactData data = artefactData;
        GrClassDefinition grClassDefinition = (GrClassDefinition)CollectionsKt.singleOrNull((Iterable)GrailsArtifact.DOMAIN.getInstances(data.getModule(), data.getPackageName(), data.getArtefactName()));
        if (grClassDefinition == null) {
            return;
        }
        GrClassDefinition domainClass = grClassDefinition;
        String string = domainClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String domainClassName = string;
        GrailsCommandExecutorUtil.execute(data.getApplication(), new MvcCommand(this.command, new String[]{domainClassName}), new Runnable(this, data){
            final /* synthetic */ GenerateActionBase this$0;
            final /* synthetic */ ArtefactData $data;

            public final void run() {
                LocalFileSystem.getInstance().refreshFiles((Iterable)CollectionsKt.listOf((Object)this.$data.getApplication().getRoot()), true, true, new Runnable(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public final void run() {
                        this.this$0.this$0.onDone(this.this$0.$data);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = generateActionBase;
                this.$data = artefactData;
            }
        });
    }

    public boolean isEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        ArtefactData artefactData = GrailsActionUtilKt.getArtefactData(dataContext);
        if (artefactData == null) {
            return false;
        }
        ArtefactData data = artefactData;
        GrClassDefinition domainClass = (GrClassDefinition)CollectionsKt.singleOrNull((Iterable)GrailsArtifact.DOMAIN.getInstances(data.getModule(), data.getPackageName(), data.getArtefactName()));
        return domainClass != null && this.isEnabled(data);
    }

    public boolean isEnabled(@NotNull ArtefactData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return GrailsCommandExecutor.getGrailsExecutor(data.getApplication()) != null;
    }

    public void onDone(@NotNull ArtefactData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public GenerateActionBase(@NotNull String command, @Nullable String text, @Nullable Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        super(text, null, icon);
        this.command = command;
    }
}

