/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.fileType;

import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.util.XmlUtil;
import icons.GroovyMvcIcons;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.highlighter.GspEditorHighlighter;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.directive.GspDirectiveAttributeValueImpl;

public class GspFileType
extends XmlLikeFileType {
    public static final String GSP_EXTENSION = "gsp";
    public static final GspFileType GSP_FILE_TYPE = new GspFileType();

    private GspFileType() {
        super((Language)GspLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/plugins/grails/fileType/GspFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "org/jetbrains/plugins/grails/fileType/GspFileType$1", "getEditorHighlighter"));
                }
                return new GspEditorHighlighter(colors, project, virtualFile);
            }
        });
    }

    @NotNull
    public String getDefaultExtension() {
        if (GSP_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/fileType/GspFileType", "getDefaultExtension"));
        }
        return GSP_EXTENSION;
    }

    @NotNull
    public String getDescription() {
        if ("Groovy Server Pages" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/fileType/GspFileType", "getDescription"));
        }
        return "Groovy Server Pages";
    }

    public Icon getIcon() {
        return GroovyMvcIcons.Gsp_logo;
    }

    @NotNull
    public String getName() {
        if ("GSP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/fileType/GspFileType", "getName"));
        }
        return "GSP";
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    public Charset extractCharsetFromFileContent(Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/grails/fileType/GspFileType", "extractCharsetFromFileContent"));
        }
        String name = XmlUtil.extractXmlEncodingFromProlog((CharSequence)content);
        Charset charset = CharsetToolkit.forName((String)name);
        if (charset != null) {
            return charset;
        }
        charset = GspFileType.extractCharset(content);
        if (charset != null) {
            return charset;
        }
        return CharsetToolkit.UTF8_CHARSET;
    }

    @Nullable
    private static Charset extractCharset(@NotNull CharSequence content) {
        IElementType tokenType;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/grails/fileType/GspFileType", "extractCharset"));
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)GspLanguage.INSTANCE);
        if (definition == null) {
            return null;
        }
        Lexer lexer = definition.createLexer(null);
        lexer.start(content);
        while ((tokenType = lexer.getTokenType()) != null) {
            String name;
            Charset charset;
            Matcher matcher;
            if (tokenType == GspTokenTypes.GSP_DIRECTIVE && (matcher = GspDirectiveAttributeValueImpl.CHARSET_PATTERN.matcher(lexer.getTokenSequence())).find() && (charset = CharsetToolkit.forName((String)(name = matcher.group(1)))) != null) {
                return charset;
            }
            lexer.advance();
        }
        return null;
    }
}

