/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public abstract class GrailsI18nizeQuickFixDialog
extends JavaI18nizeQuickFixDialog {
    public GrailsI18nizeQuickFixDialog(@NotNull Project project, @NotNull PsiFile context, @NotNull String defaultPropertyValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/i18n/GrailsI18nizeQuickFixDialog", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/i18n/GrailsI18nizeQuickFixDialog", "<init>"));
        }
        if (defaultPropertyValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPropertyValue", "org/jetbrains/plugins/grails/i18n/GrailsI18nizeQuickFixDialog", "<init>"));
        }
        super(project, context, null, defaultPropertyValue, null, false, true);
    }

    @Nullable
    protected abstract String getArgs();

    protected void addAdditionalAttributes(Map<String, String> attributes) {
        attributes.put("ARGS_KEY", this.getArgs());
        attributes.put("PROPERTY_VALUE", this.myDefaultPropertyValue);
    }

    public String getDefaultPropertyValue() {
        return this.myDefaultPropertyValue;
    }

    protected List<String> defaultSuggestPropertiesFiles() {
        VirtualFile i18nFile = GrailsUtils.findI18nDirectory((PsiElement)this.myContext);
        if (i18nFile == null) {
            return super.defaultSuggestPropertiesFiles();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (VirtualFile virtualFile : i18nFile.getChildren()) {
            if (!virtualFile.getName().endsWith(".properties")) continue;
            res.add(virtualFile.getPath());
        }
        Collections.sort(res);
        return res;
    }

    @NotNull
    protected abstract String getTemplateName();
}

