/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.GspDirectiveKindStatic;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.directive.GspDirective;

public enum GspDirectiveKind {
    PAGE("page", "tag"),
    INCLUDE("include"),
    TAGLIB("taglib"),
    ATTRIBUTE("attribute"),
    VARIABLE("variable");

    private final String[] tagNames;

    private GspDirectiveKind(String ... tagNames) {
        this.tagNames = tagNames;
    }

    public String[] getTagNames() {
        return this.tagNames;
    }

    public boolean isInstance(@NotNull GspDirective directive) {
        if (directive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "org/jetbrains/plugins/grails/lang/gsp/GspDirectiveKind", "isInstance"));
        }
        return GspDirectiveKind.getKind(directive) == this;
    }

    @Nullable
    public static GspDirectiveKind getKind(@NotNull GspDirective directive) {
        if (directive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "org/jetbrains/plugins/grails/lang/gsp/GspDirectiveKind", "getKind"));
        }
        return GspDirectiveKindStatic.KIND_MAP.get(directive.getName());
    }
}

