/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter.processors;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspXmlRootTag;

public class GspIndentProcessor
implements GspTokenTypesEx {
    private GspIndentProcessor() {
    }

    @NotNull
    public static Indent getGspChildIndent(@NotNull ASTNode parent, @NotNull ASTNode child, XmlFormattingPolicy policy) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
        }
        PsiElement parentPsi = parent.getPsi();
        PsiElement childPsi = child.getPsi();
        if (parentPsi instanceof GspXmlRootTag) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
            }
            return indent;
        }
        if (parentPsi instanceof XmlTag) {
            if (GspTokenTypesEx.GSP_GROOVY_SEPARATORS.contains(child.getElementType())) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
                }
                return indent;
            }
            if (childPsi instanceof XmlTag || childPsi instanceof XmlText || XML_DATA_CHARACTERS == child.getElementType()) {
                Indent indent = GspIndentProcessor.indentForHtmlTag(policy, (XmlTag)parent);
                if (indent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
                }
                return indent;
            }
            if (childPsi instanceof OuterLanguageElement) {
                if (JavaScriptIntegrationUtil.isJavaScriptInjection(childPsi)) {
                    Indent indent = Indent.getNormalIndent();
                    if (indent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
                    }
                    return indent;
                }
                Indent indent = parentPsi instanceof HtmlTag ? GspIndentProcessor.indentForHtmlTag(policy, (XmlTag)((HtmlTag)parentPsi)) : Indent.getNormalIndent();
                if (indent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
                }
                return indent;
            }
            if (childPsi instanceof XmlAttribute) {
                Indent indent = Indent.getContinuationIndent();
                if (indent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
                }
                return indent;
            }
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor", "getGspChildIndent"));
        }
        return indent;
    }

    public static Indent indentForHtmlTag(XmlFormattingPolicy policy, XmlTag parent) {
        return policy.indentChildrenOf(parent) ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }
}

