/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class ArtifactPropertyGetterReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public ArtifactPropertyGetterReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/grails/references/common/ArtifactPropertyGetterReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/grails/references/common/ArtifactPropertyGetterReferenceSearcher", "processQuery"));
        }
        PsiMethod elementToSearch = queryParameters.getMethod();
        if (!(elementToSearch instanceof GrMethod)) {
            return;
        }
        GrMethod getter = (GrMethod)elementToSearch;
        if (!PropertyUtil.isSimplePropertyGetter((PsiMethod)getter)) {
            return;
        }
        ArtifactPropertyGetterReferenceSearcher.searchReferences((PsiMethod)getter, (PsiElement)getter, queryParameters.getEffectiveSearchScope(), queryParameters.getOptimizer());
    }

    static void searchReferences(@NotNull PsiMethod getter, PsiElement elementToSearch, @NotNull SearchScope scope2, @NotNull SearchRequestCollector optimizer) {
        String fieldName;
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "org/jetbrains/plugins/grails/references/common/ArtifactPropertyGetterReferenceSearcher", "searchReferences"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/grails/references/common/ArtifactPropertyGetterReferenceSearcher", "searchReferences"));
        }
        if (optimizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optimizer", "org/jetbrains/plugins/grails/references/common/ArtifactPropertyGetterReferenceSearcher", "searchReferences"));
        }
        PsiClass psiClass = getter.getContainingClass();
        GrailsArtifact artifact = GrailsArtifact.getType(psiClass);
        if (artifact == null && GormUtils.isStandaloneGormBean(psiClass)) {
            artifact = GrailsArtifact.DOMAIN;
        }
        if (artifact != GrailsArtifact.CONTROLLER && artifact != GrailsArtifact.TAGLIB && artifact != GrailsArtifact.DOMAIN) {
            return;
        }
        String propertyName = GroovyPropertyUtils.getPropertyNameByGetterName((String)getter.getName(), (boolean)true);
        assert (propertyName != null);
        short searchContext = 0;
        if (artifact == GrailsArtifact.CONTROLLER || artifact == GrailsArtifact.DOMAIN) {
            searchContext = (short)(searchContext | 4);
        }
        if (elementToSearch instanceof GrField && (fieldName = ((GrField)elementToSearch).getName()) != null && !fieldName.equals(propertyName)) {
            searchContext = (short)(searchContext | 8);
        }
        if (searchContext == 0) {
            return;
        }
        if (scope2 instanceof GlobalSearchScope) {
            scope2 = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope2), (FileType[])new FileType[]{GroovyFileType.GROOVY_FILE_TYPE, GspFileType.GSP_FILE_TYPE});
        }
        optimizer.searchWord(propertyName, scope2, searchContext, true, elementToSearch);
    }
}

