/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;

public class XmlGspTagWrapper
implements GspTagWrapper {
    private final XmlTag myTag;

    public XmlGspTagWrapper(XmlTag tag) {
        this.myTag = tag;
    }

    @Override
    @NotNull
    public String getTagName() {
        String string = this.myTag.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/XmlGspTagWrapper", "getTagName"));
        }
        return string;
    }

    @Override
    public boolean hasAttribute(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/references/common/XmlGspTagWrapper", "hasAttribute"));
        }
        return this.myTag.getAttribute(name) != null;
    }

    public XmlAttributeValue getAttributeValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/references/common/XmlGspTagWrapper", "getAttributeValue"));
        }
        XmlAttribute attrValue = this.myTag.getAttribute(name);
        if (attrValue == null) {
            return null;
        }
        return attrValue.getValueElement();
    }

    @Override
    public PsiType getAttributeValueType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/references/common/XmlGspTagWrapper", "getAttributeValueType"));
        }
        XmlAttributeValue attribute = this.getAttributeValue(name);
        if (attribute == null) {
            return null;
        }
        return GrailsPsiUtil.getAttributeExpressionType(attribute);
    }

    @Override
    public String getAttributeText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/XmlGspTagWrapper", "getAttributeText"));
        }
        XmlAttributeValue attributeValue = (XmlAttributeValue)element;
        if (!GrailsPsiUtil.isSimpleAttribute(attributeValue)) {
            return null;
        }
        return attributeValue.getValue();
    }

    @Override
    public List<String> getAttributeNames() {
        XmlAttribute[] attributes = this.myTag.getAttributes();
        ArrayList<String> res = new ArrayList<String>(attributes.length);
        for (XmlAttribute attribute : attributes) {
            res.add(attribute.getName());
        }
        return res;
    }
}

