/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.pluginClass;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ProcessingContext;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;

public class GrailsPluginListReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider", "getReferencesByElement"));
        }
        PsiField aField = (PsiField)element.getParent().getParent();
        PsiClass aClass = aField.getContainingClass();
        if (!GrailsUtils.isGrailsPluginClass(aClass)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiPolyVariantReferenceBase<PsiElement>(element, false){

            private String extractPluginName(String fileName) {
                String str = fileName.substring(0, fileName.length() - "GrailsPlugin.groovy".length());
                return StringUtil.decapitalize((String)str);
            }

            @NotNull
            public Object[] getVariants() {
                HashSet<Object> existingPlugins = new HashSet<Object>();
                PsiElement element = this.getElement();
                existingPlugins.add(this.extractPluginName(element.getContainingFile().getOriginalFile().getName()));
                GrListOrMap list = (GrListOrMap)element.getParent();
                for (GrExpression expression : list.getInitializers()) {
                    if (expression == element || !(expression instanceof GrLiteralImpl)) continue;
                    existingPlugins.add(((GrLiteralImpl)expression).getValue());
                }
                ArrayList<LookupElementBuilder> res = new ArrayList<LookupElementBuilder>();
                Project project = element.getProject();
                for (String fileName : FilenameIndex.getAllFilenames((Project)project)) {
                    PsiFile[] files;
                    if (!fileName.endsWith("GrailsPlugin.groovy") || fileName.length() <= "GrailsPlugin.groovy".length()) continue;
                    block2: for (PsiFile file : files = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))) {
                        if (!(file instanceof GroovyFile)) continue;
                        for (PsiClass psiClass : ((GroovyFile)file).getClasses()) {
                            if (psiClass.hasModifierProperty("abstract") || !psiClass.getName().endsWith("GrailsPlugin")) continue;
                            String str = this.extractPluginName(fileName);
                            if (!existingPlugins.add(str)) continue block2;
                            res.add(LookupElementBuilder.create((String)str).withIcon(JetgroovyIcons.Mvc.Groovy_mvc_plugin));
                            continue block2;
                        }
                    }
                }
                Object[] objectArray = res.toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }

            @NotNull
            public ResolveResult[] multiResolve(boolean incompleteCode) {
                GlobalSearchScope searchScope;
                String value = this.getValue();
                if (value.length() == 0) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider$1", "multiResolve"));
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                String fileName = StringUtil.capitalize((String)value) + "GrailsPlugin.groovy";
                Project project = this.getElement().getProject();
                PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)(searchScope = GlobalSearchScope.allScope((Project)project)));
                if (files.length == 0) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider$1", "multiResolve"));
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                ArrayList<GroovyResolveResultImpl> res = new ArrayList<GroovyResolveResultImpl>(files.length);
                block0: for (PsiFile file : files) {
                    if (!(file instanceof GroovyFile)) continue;
                    for (PsiClass psiClass : ((GroovyFile)file).getClasses()) {
                        if (psiClass.hasModifierProperty("abstract") || !psiClass.getName().endsWith("GrailsPlugin")) continue;
                        res.add(new GroovyResolveResultImpl((PsiElement)psiClass, true));
                        continue block0;
                    }
                }
                ResolveResult[] resolveResultArray = res.toArray(new ResolveResult[res.size()]);
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider$1", "multiResolve"));
                }
                return resolveResultArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/pluginClass/GrailsPluginListReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

