/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GroovyGspTagWrapper;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.common.PluginSupportFileReferenceSet;
import org.jetbrains.plugins.grails.references.common.ResourceDirAttributeFileReferenceSet;
import org.jetbrains.plugins.grails.references.tagSupport.GspResourceDirAttributeSupport;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentReferenceProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;

public class GspResourceFileAttributeSupport
extends TagAttributeReferenceProvider
implements GroovyNamedArgumentReferenceProvider {
    public GspResourceFileAttributeSupport() {
        super("file", "g", GspResourceDirAttributeSupport.TAGS);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = GspResourceFileAttributeSupport.createReferences(element, gspTagWrapper);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] createReferences(@NotNull PsiElement psiElement, final @NotNull GspTagWrapper gspTagWrapper) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "createReferences"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "createReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        TextRange range = manipulator.getRangeInElement(psiElement);
        int offset = range.getStartOffset();
        String text = range.substring(psiElement.getText());
        String trimedUrl = PathReference.trimPath((String)text);
        if (trimedUrl.trim().length() == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        ResourceDirAttributeFileReferenceSet set = new ResourceDirAttributeFileReferenceSet(trimedUrl, psiElement, offset, null, true, true){

            @Override
            protected PsiElement getPluginElement() {
                return gspTagWrapper.getAttributeValue("plugin");
            }

            @Override
            protected PsiElement getContextPathElement() {
                return gspTagWrapper.getAttributeValue("contextPath");
            }

            @Override
            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                FileReference dirFileReference = 1.extractReference(gspTagWrapper.getAttributeValue("dir"));
                if (dirFileReference != null) {
                    if (dirFileReference instanceof PluginSupportFileReferenceSet.PluginDirReference) {
                        List<PsiFileSystemItem> list = Collections.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport$1", "computeDefaultContexts"));
                        }
                        return list;
                    }
                    ArrayList<PsiFileSystemItem> res = new ArrayList<PsiFileSystemItem>();
                    for (ResolveResult resolveResult : dirFileReference.multiResolve(false)) {
                        PsiElement item = resolveResult.getElement();
                        if (!(item instanceof PsiFileSystemItem)) continue;
                        res.add((PsiFileSystemItem)item);
                    }
                    ArrayList<PsiFileSystemItem> arrayList = res;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport$1", "computeDefaultContexts"));
                    }
                    return arrayList;
                }
                Collection<PsiFileSystemItem> collection = super.computeDefaultContexts();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport$1", "computeDefaultContexts"));
                }
                return collection;
            }

            @Override
            protected boolean isAcceptToCompletion(@NotNull VirtualFile fileOrDir) {
                if (fileOrDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport$1", "isAcceptToCompletion"));
                }
                return true;
            }
        };
        return set.getAllReferences();
    }

    public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrNamedArgument namedArgument, @NotNull GroovyResolveResult resolveResult, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "createRef"));
        }
        if (namedArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "createRef"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "createRef"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceFileAttributeSupport", "createRef"));
        }
        return GspResourceFileAttributeSupport.createReferences(element, new GroovyGspTagWrapper((GrNamedArgumentsOwner)namedArgument.getParent(), null));
    }
}

