/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LocatableRunConfigurationWithCommonParameters
extends LocatableConfigurationBase {
    private String myProgramParameters;
    private String myVMParameters;
    private final Map<String, String> myEnvs;
    private boolean myPassParentEnv;

    protected LocatableRunConfigurationWithCommonParameters(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/runner/LocatableRunConfigurationWithCommonParameters", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/plugins/grails/runner/LocatableRunConfigurationWithCommonParameters", "<init>"));
        }
        super(project, factory, name);
        this.myEnvs = new HashMap();
        this.myPassParentEnv = true;
    }

    @Nullable
    public String getProgramParameters() {
        return this.myProgramParameters;
    }

    public void setProgramParameters(@Nullable String value) {
        this.myProgramParameters = value;
    }

    public String getVMParameters() {
        return this.myVMParameters;
    }

    public void setVMParameters(String vmParams) {
        this.myVMParameters = vmParams;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.myEnvs;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/LocatableRunConfigurationWithCommonParameters", "getEnvs"));
        }
        return map2;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "org/jetbrains/plugins/grails/runner/LocatableRunConfigurationWithCommonParameters", "setEnvs"));
        }
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnv;
    }

    public void setPassParentEnvs(boolean passParentEnv) {
        this.myPassParentEnv = passParentEnv;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myVMParameters = JDOMExternalizer.readString((Element)element, (String)"vmparams");
        this.myProgramParameters = JDOMExternalizer.readString((Element)element, (String)"cmdLine");
        String sPassParentEnvironment = JDOMExternalizer.readString((Element)element, (String)"passParentEnv");
        this.myPassParentEnv = StringUtil.isEmpty((String)sPassParentEnvironment) || Boolean.parseBoolean(sPassParentEnvironment);
        this.myEnvs.clear();
        JDOMExternalizer.readMap((Element)element, this.myEnvs, null, (String)"env");
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizer.write((Element)element, (String)"vmparams", (String)this.myVMParameters);
        JDOMExternalizer.write((Element)element, (String)"cmdLine", (String)this.myProgramParameters);
        JDOMExternalizer.writeMap((Element)element, this.myEnvs, null, (String)"env");
        JDOMExternalizer.write((Element)element, (String)"passParentEnv", (boolean)this.myPassParentEnv);
    }
}

