/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.impl;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.gradle.GrailsModuleData;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationProvider;
import org.jetbrains.plugins.grails.structure.impl.Grails3MultiModuleApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails3SingleModuleApplication;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/grails/structure/impl/Grails3ApplicationProvider;", "Lorg/jetbrains/plugins/grails/structure/GrailsApplicationProvider;", "()V", "createApplication", "Lorg/jetbrains/plugins/grails/structure/GrailsApplication;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "groovy-mvc"})
public final class Grails3ApplicationProvider
extends GrailsApplicationProvider {
    @Override
    @Nullable
    public GrailsApplication createApplication(@NotNull Project project, @NotNull VirtualFile root) {
        GrailsApplication grailsApplication2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        String path = root.getPath();
        AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        ExternalProjectSettings externalProjectSettings = settings.getLinkedProjectSettings(path);
        if (!(externalProjectSettings instanceof GradleProjectSettings)) {
            externalProjectSettings = null;
        }
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)externalProjectSettings;
        if (gradleProjectSettings == null) {
            return null;
        }
        GradleProjectSettings linkedProjectSettings = gradleProjectSettings;
        ExternalProjectInfo externalProjectInfo = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, linkedProjectSettings.getExternalProjectPath());
        if (externalProjectInfo == null) {
            return null;
        }
        ExternalProjectInfo gradleProjectInfo = externalProjectInfo;
        DataNode dataNode = GradleProjectResolverUtil.findModule((DataNode)gradleProjectInfo.getExternalProjectStructure(), (String)path);
        if (dataNode == null) {
            return null;
        }
        DataNode moduleData = dataNode;
        if (ExternalSystemApiUtil.find((DataNode)moduleData, GrailsModuleData.KEY) == null) {
            return null;
        }
        if (linkedProjectSettings.isResolveModulePerSourceSet()) {
            DataNode dataNode2 = moduleData;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"moduleData");
            grailsApplication2 = new Grails3MultiModuleApplication(project, root, (DataNode<ModuleData>)dataNode2);
        } else {
            Grails3SingleModuleApplication grails3SingleModuleApplication;
            Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(root);
            if (module != null) {
                Module module2;
                Module module3;
                Module module4 = module3 = (module2 = module);
                Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
                DataNode dataNode3 = moduleData;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode3, (String)"moduleData");
                grails3SingleModuleApplication = new Grails3SingleModuleApplication(module4, root, (DataNode<ModuleData>)dataNode3);
            } else {
                grails3SingleModuleApplication = null;
            }
            grailsApplication2 = grails3SingleModuleApplication;
        }
        return grailsApplication2;
    }
}

