/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.groovy.steps;

import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GrStepDefinition
extends AbstractStepDefinition
implements PomNamedTarget {
    public GrStepDefinition(GrMethodCall stepDefinition) {
        super((PsiElement)stepDefinition);
    }

    public static GrStepDefinition getStepDefinition(GrMethodCall statement) {
        return (GrStepDefinition)((Object)CachedValuesManager.getCachedValue((PsiElement)statement, () -> {
            Document document = PsiDocumentManager.getInstance((Project)statement.getProject()).getDocument(statement.getContainingFile());
            return CachedValueProvider.Result.create((Object)((Object)new GrStepDefinition(statement)), (Object[])new Object[]{document});
        }));
    }

    public List<String> getVariableNames() {
        PsiElement element = this.getElement();
        if (element instanceof GrMethodCall) {
            GrClosableBlock[] closures = ((GrMethodCall)element).getClosureArguments();
            assert (closures.length == 1);
            GrParameter[] parameters = closures[0].getParameterList().getParameters();
            ArrayList<String> result = new ArrayList<String>();
            for (GrParameter parameter : parameters) {
                result.add(parameter.getName());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    protected String getCucumberRegexFromElement(PsiElement element) {
        if (!(element instanceof GrMethodCall)) {
            return null;
        }
        return GrCucumberUtil.getStepDefinitionPatternText((GrMethodCall)element);
    }

    public String getName() {
        return this.getCucumberRegex();
    }

    public boolean isValid() {
        PsiElement element = this.getElement();
        return element != null && element.isValid();
    }

    public void navigate(boolean requestFocus) {
        Navigatable descr = EditSourceUtil.getDescriptor((PsiElement)this.getElement());
        if (descr != null) {
            descr.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return EditSourceUtil.canNavigate((PsiElement)this.getElement());
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }
}

