/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.groovy.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import cucumber.runtime.groovy.GroovySnippet;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrStepDefinitionCreator
implements StepDefinitionCreator {
    public static final String GROOVY_STEP_DEFINITION_FILE_TMPL_1_0 = "GroovyStepDefinitionFile.groovy";
    public static final String GROOVY_STEP_DEFINITION_FILE_TMPL_1_1 = "GroovyStepDefinitionFile1_1.groovy";

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        String fileName = name + '.' + "groovy";
        if (GrCucumberUtil.isCucumber_1_1_orAbove((PsiElement)dir)) {
            PsiFile psiFile = GroovyTemplatesFactory.createFromTemplate((PsiDirectory)dir, (String)name, (String)fileName, (String)GROOVY_STEP_DEFINITION_FILE_TMPL_1_1, (boolean)true, (String[])new String[0]);
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "createStepDefinitionContainer"));
            }
            return psiFile;
        }
        PsiFile psiFile = GroovyTemplatesFactory.createFromTemplate((PsiDirectory)dir, (String)name, (String)fileName, (String)GROOVY_STEP_DEFINITION_FILE_TMPL_1_0, (boolean)true, (String[])new String[0]);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, final @NotNull PsiFile file) {
        GrParameter[] blockVars;
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "createStepDefinition"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "createStepDefinition"));
        }
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        final Project project = file.getProject();
        VirtualFile vFile = (VirtualFile)ObjectUtils.assertNotNull((Object)file.getVirtualFile());
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vFile);
        FileEditorManager.getInstance((Project)project).getAllEditors(vFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        final Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            TemplateManager templateManager = TemplateManager.getInstance((Project)file.getProject());
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
            Template template = templateManager.getActiveTemplate(editor);
            if (templateState != null && template != null) {
                templateState.gotoEnd();
            }
        }
        GrMethodCall element = GrStepDefinitionCreator.buildStepDefinitionByStep(step);
        GrMethodCall methodCall = (GrMethodCall)((GroovyFile)file).addStatementBefore((GrStatement)element, null);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)methodCall);
        methodCall = (GrMethodCall)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)methodCall);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)methodCall);
        GrLiteral pattern = GrCucumberUtil.getStepDefinitionPattern(methodCall);
        assert (pattern != null);
        String patternText = pattern.getText();
        builder.replaceElement((PsiElement)pattern, new TextRange(1, patternText.length() - 1), patternText.substring(1, patternText.length() - 1));
        GrClosableBlock closure = methodCall.getClosureArguments()[0];
        for (GrParameter var : blockVars = closure.getAllParameters()) {
            PsiElement identifier = var.getNameIdentifierGroovy();
            builder.replaceElement(identifier, identifier.getText());
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        final Editor editorToRunTemplate = editor == null ? IntentionUtils.positionCursor((Project)project, (PsiFile)file, (PsiElement)methodCall) : editor;
        Template template = builder.buildTemplate();
        TextRange range = methodCall.getTextRange();
        editorToRunTemplate.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editorToRunTemplate.getCaretModel().moveToOffset(range.getStartOffset());
        manager.startTemplate(editorToRunTemplate, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                if (brokenOff) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    GrClosableBlock[] closures;
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator$1", "lambda$templateFinished$0"));
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editorToRunTemplate.getDocument());
                    int offset = editorToRunTemplate.getCaretModel().getOffset();
                    GrMethodCall methodCall1 = (GrMethodCall)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), GrMethodCall.class, (boolean)false);
                    if (methodCall1 != null && (closures = methodCall1.getClosureArguments()).length == 1) {
                        GrClosableBlock closure1 = closures[0];
                        GrStepDefinitionCreator.selectBody(closure1, editor);
                    }
                });
            }
        });
        return true;
    }

    private static void selectBody(GrClosableBlock closure, Editor editor) {
        PsiElement rightBound;
        PsiElement arrow = closure.getArrow();
        PsiElement leftBound = PsiUtil.skipWhitespaces((PsiElement)(arrow != null ? arrow : closure.getParameterList()).getNextSibling(), (boolean)true);
        PsiElement rbrace = closure.getRBrace();
        PsiElement psiElement = rightBound = rbrace != null ? PsiUtil.skipWhitespaces((PsiElement)rbrace.getPrevSibling(), (boolean)false) : null;
        if (leftBound != null && rightBound != null) {
            editor.getSelectionModel().setSelection(leftBound.getTextRange().getStartOffset(), rightBound.getTextRange().getEndOffset());
            editor.getCaretModel().moveToOffset(leftBound.getTextRange().getStartOffset());
        }
    }

    private static GrMethodCall buildStepDefinitionByStep(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "buildStepDefinitionByStep"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)step.getProject());
        Step cucumberStep = new Step(Collections.emptyList(), step.getKeyword().getText(), step.getStepName(), Integer.valueOf(0), null, null);
        SnippetGenerator generator = new SnippetGenerator((Snippet)new GroovySnippet());
        String fqnPendingException = GrCucumberUtil.isCucumber_1_1_orAbove((PsiElement)step) ? "cucumber.api.PendingException" : "cucumber.runtime.PendingException";
        String snippet = generator.getSnippet(cucumberStep, null).replace("PendingException", fqnPendingException);
        return (GrMethodCall)factory.createStatementFromText((CharSequence)snippet, (PsiElement)step);
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "validateNewStepDefinitionFileName"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "validateNewStepDefinitionFileName"));
        }
        return true;
    }

    @NotNull
    public PsiDirectory getDefaultStepDefinitionFolder(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
        }
        PsiFile featureFile = step.getContainingFile();
        PsiDirectory psiDirectory = (PsiDirectory)ObjectUtils.assertNotNull((Object)featureFile.getParent());
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
        }
        return psiDirectory;
    }

    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (file instanceof GroovyFile && vFile != null) {
            String packageName = ((GroovyFile)file).getPackageName();
            if (StringUtil.isEmptyOrSpaces((String)packageName)) {
                String string = vFile.getNameWithoutExtension();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getStepDefinitionFilePath"));
                }
                return string;
            }
            String string = packageName + "." + vFile.getNameWithoutExtension();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getStepDefinitionFilePath"));
            }
            return string;
        }
        String string = file.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        return string;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getDefaultStepFileName"));
        }
        if ("StepDef" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator", "getDefaultStepFileName"));
        }
        return "StepDef";
    }
}

