/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.geronimo.GeronimoBundle;
import com.intellij.javaee.oss.geronimo.server.GeronimoAdminPortConfig;
import com.intellij.javaee.oss.geronimo.server.GeronimoHttpPortConfig;
import com.intellij.javaee.oss.geronimo.server.GeronimoLocalEditor;
import com.intellij.javaee.oss.geronimo.server.GeronimoServerModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;

class GeronimoLocalModel
extends GeronimoServerModel {
    GeronimoLocalModel() {
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new GeronimoLocalEditor();
    }

    public int getLocalPort() {
        return GeronimoHttpPortConfig.getLocal(this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getServerPort() == Integer.MAX_VALUE) {
            throw new RuntimeConfigurationError(GeronimoBundle.getText("GeronimoLocalModel.error.invalid", new Object[0]));
        }
        if (this.getServerPort() <= 0) {
            throw new RuntimeConfigurationError(GeronimoBundle.getText("GeronimoLocalModel.error.disabled", new Object[0]));
        }
        super.checkConfiguration();
    }

    protected int getServerPort() {
        return GeronimoAdminPortConfig.getAdmin(this);
    }

    @Nullable
    protected String getLogFilePath(String home) {
        if (!StringUtil.isEmpty((String)home)) {
            return new File(home, "var/log/geronimo.log").getAbsolutePath();
        }
        return null;
    }
}

