/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees.cloud;

import com.intellij.javaee.cloudbees.CBContainerType;
import com.intellij.javaee.cloudbees.cloud.CBDeploymentConfiguration;
import com.intellij.javaee.cloudbees.cloud.CBDeploymentEditor;
import com.intellij.javaee.cloudbees.cloud.CBServerConfiguration;
import com.intellij.javaee.ui.packaging.EarArtifactType;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.JavaDeploymentSourceUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CBDeploymentConfigurator
extends DeploymentConfigurator<CBDeploymentConfiguration, CBServerConfiguration> {
    private final Project myProject;

    public CBDeploymentConfigurator(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<DeploymentSource> getAvailableDeploymentSources() {
        List list = JavaDeploymentSourceUtil.getInstance().createArtifactDeploymentSources(this.myProject, new ArtifactType[]{WarArtifactType.getInstance(), EarArtifactType.getInstance()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudbees/cloud/CBDeploymentConfigurator", "getAvailableDeploymentSources"));
        }
        return list;
    }

    @NotNull
    public CBDeploymentConfiguration createDefaultConfiguration(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/cloudbees/cloud/CBDeploymentConfigurator", "createDefaultConfiguration"));
        }
        CBDeploymentConfiguration result = new CBDeploymentConfiguration();
        result.setContainerType(CBContainerType.TOMCAT);
        CBDeploymentConfiguration cBDeploymentConfiguration = result;
        if (cBDeploymentConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudbees/cloud/CBDeploymentConfigurator", "createDefaultConfiguration"));
        }
        return cBDeploymentConfiguration;
    }

    @Nullable
    public SettingsEditor<CBDeploymentConfiguration> createEditor(@NotNull DeploymentSource source, @NotNull RemoteServer<CBServerConfiguration> server) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/cloudbees/cloud/CBDeploymentConfigurator", "createEditor"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/cloudbees/cloud/CBDeploymentConfigurator", "createEditor"));
        }
        return new CBDeploymentEditor();
    }
}

