/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.codeInsight.daemon.impl.JavaProjectSdkSetupValidator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxProjectSdkSetupValidator
implements ProjectSdkSetupValidator {
    public boolean isApplicableFor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator", "isApplicableFor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator", "isApplicableFor"));
        }
        return JavaFxFileTypeFactory.isFxml(file);
    }

    @Nullable
    public String getErrorMessage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator", "getErrorMessage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator", "getErrorMessage"));
        }
        String javaErrorMessage = JavaProjectSdkSetupValidator.INSTANCE.getErrorMessage(project, file);
        if (javaErrorMessage != null) {
            return javaErrorMessage;
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        PsiClass nodeClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.scene.Node", GlobalSearchScope.allScope((Project)project));
        if (nodeClass == null) {
            return "The JavaFX runtime is not configured. Either use a JDK that has the JavaFX built in, or add a JavaFX library to the classpath";
        }
        return null;
    }

    public void doFix(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator", "doFix"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator", "doFix"));
        }
        String javaErrorMessage = JavaProjectSdkSetupValidator.INSTANCE.getErrorMessage(project, file);
        if (javaErrorMessage != null) {
            JavaProjectSdkSetupValidator.INSTANCE.doFix(project, file);
            return;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        String moduleName = module != null && !module.isDisposed() ? module.getName() : null;
        ProjectSettingsService.getInstance((Project)project).showModuleConfigurationDialog(moduleName, ClasspathEditor.NAME);
    }
}

