/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxReferencesContributor;

public class JavaFxConvertCssToBinaryIntention
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/css/intentions/JavaFxConvertCssToBinaryIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/css/intentions/JavaFxConvertCssToBinaryIntention", "invoke"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiLiteralExpression)) {
            return;
        }
        Object value = ((PsiLiteralExpression)parent).getValue();
        if (!(value instanceof String)) {
            return;
        }
        int cssIdx = ((String)value).indexOf(".css");
        if (cssIdx < 0) {
            return;
        }
        String bss = "getClass().getResource(\"" + ((String)value).substring(0, cssIdx) + ".bss\").toExternalForm()";
        parent.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(bss, parent));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/css/intentions/JavaFxConvertCssToBinaryIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/css/intentions/JavaFxConvertCssToBinaryIntention", "isAvailable"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiLiteralExpression && JavaFxReferencesContributor.STYLESHEET_PATTERN.accepts((Object)parent)) {
            Object value = ((PsiLiteralExpression)parent).getValue();
            this.setText(this.getFamilyName());
            return value instanceof String && ((String)value).endsWith(".css");
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Use binary css file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/intentions/JavaFxConvertCssToBinaryIntention", "getFamilyName"));
        }
        return "Use binary css file";
    }
}

