/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;

public class JavaFxComponentIdReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
        }
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)element;
        String value = xmlAttributeValue.getValue();
        if (JavaFxPsiUtil.isIncorrectExpressionBinding(value)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlTag.class);
        Map<String, XmlAttributeValue> fileIds = JavaFxPsiUtil.collectFileIds(currentTag);
        if (JavaFxPsiUtil.isExpressionBinding(value)) {
            PsiReference[] psiReferenceArray = JavaFxComponentIdReferenceProvider.getExpressionReferences(element, xmlAttributeValue, value, fileIds);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (value.startsWith("$")) {
            PsiReference[] psiReferenceArray = JavaFxComponentIdReferenceProvider.getSinglePropertyReferences(xmlAttributeValue, value, fileIds);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        HashSet<String> acceptableIds = new HashSet<String>();
        if (currentTag != null) {
            XmlTag parentTag = currentTag.getParentTag();
            for (String id : fileIds.keySet()) {
                XmlAttributeValue resolvedAttrValue = fileIds.get(id);
                if (!JavaFxPsiUtil.isClassAcceptable(parentTag, JavaFxPsiUtil.getTagClass(resolvedAttrValue))) continue;
                acceptableIds.add(id);
            }
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JavaFxIdReferenceBase(xmlAttributeValue, fileIds, acceptableIds, value)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getExpressionReferences(@NotNull PsiElement element, @NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value, @NotNull Map<String, XmlAttributeValue> fileIds) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
        }
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
        }
        if (fileIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
        }
        if ("${null}".equals(value)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String expressionBody = value.substring(2, value.length() - 1);
        List propertyNames = StringUtil.split((String)expressionBody, (String)".", (boolean)true, (boolean)false);
        if (JavaFxPropertyAttributeDescriptor.isIncompletePropertyChain(propertyNames)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (propertyNames.size() == 1) {
            PsiReference[] psiReferenceArray = JavaFxComponentIdReferenceProvider.getSinglePropertyReferences(xmlAttributeValue, fileIds, expressionBody, 2);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
            }
            return psiReferenceArray;
        }
        PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(element.getContainingFile());
        String firstPropertyName = (String)propertyNames.get(0);
        int positionInExpression = 2;
        ArrayList<PsiReferenceBase> result = new ArrayList<PsiReferenceBase>();
        PsiReferenceBase firstReference = JavaFxComponentIdReferenceProvider.getIdReferenceBase(xmlAttributeValue, firstPropertyName, fileIds, Collections.emptyMap(), controllerClass);
        positionInExpression = JavaFxComponentIdReferenceProvider.adjustTextRange(firstPropertyName, firstReference, positionInExpression);
        PsiClass propertyOwnerClass = "controller".equals(firstPropertyName) ? controllerClass : JavaFxPsiUtil.getTagClass(fileIds.get(firstPropertyName));
        result.add(firstReference);
        List remainingPropertyNames = propertyNames.subList(1, propertyNames.size());
        for (String propertyName : remainingPropertyNames) {
            JavaFxExpressionReferenceBase reference = new JavaFxExpressionReferenceBase(xmlAttributeValue, propertyOwnerClass, propertyName);
            positionInExpression = JavaFxComponentIdReferenceProvider.adjustTextRange(propertyName, reference, positionInExpression);
            PsiType propertyType = JavaFxPsiUtil.getReadablePropertyType(reference.resolve());
            propertyOwnerClass = propertyType instanceof PsiClassType ? ((PsiClassType)propertyType).resolve() : null;
            result.add(reference);
        }
        PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getExpressionReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getSinglePropertyReferences(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value, @NotNull Map<String, XmlAttributeValue> fileIds) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        if (fileIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        if (FxmlConstants.isNullValue(value)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = JavaFxComponentIdReferenceProvider.getSinglePropertyReferences(xmlAttributeValue, fileIds, value.substring(1), 1);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getSinglePropertyReferences(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull Map<String, XmlAttributeValue> fileIds, @NotNull String propertyName, int positionInExpression) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        if (fileIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(xmlAttributeValue.getContainingFile());
        Map<String, TypeMatch> typeMatches = JavaFxComponentIdReferenceProvider.getTypeMatches(xmlAttributeValue, fileIds);
        PsiReferenceBase reference = JavaFxComponentIdReferenceProvider.getIdReferenceBase(xmlAttributeValue, propertyName, fileIds, typeMatches, controllerClass);
        JavaFxComponentIdReferenceProvider.adjustTextRange(propertyName, reference, positionInExpression);
        PsiReference[] psiReferenceArray = new PsiReference[]{reference};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getSinglePropertyReferences"));
        }
        return psiReferenceArray;
    }

    private static Map<String, TypeMatch> getTypeMatches(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull Map<String, XmlAttributeValue> fileIds) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getTypeMatches"));
        }
        if (fileIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getTypeMatches"));
        }
        PsiClass targetPropertyClass = JavaFxPsiUtil.getWritablePropertyClass(xmlAttributeValue);
        boolean isConvertible = targetPropertyClass != null && JavaFxPsiUtil.hasConversionFromAnyType(targetPropertyClass);
        return fileIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (xmlAttributeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "lambda$getTypeMatches$0"));
            }
            PsiClass valueClass = JavaFxPsiUtil.getTagClassById((XmlAttributeValue)e.getValue(), (String)e.getKey(), (PsiElement)xmlAttributeValue);
            return TypeMatch.getMatch(valueClass, targetPropertyClass, isConvertible);
        }));
    }

    private static int adjustTextRange(@NotNull String propertyName, @NotNull PsiReferenceBase reference, int positionInExpression) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "adjustTextRange"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "adjustTextRange"));
        }
        TextRange range = reference.getRangeInElement();
        int startOffset = range.getStartOffset() + positionInExpression;
        int endOffset = startOffset + propertyName.length();
        reference.setRangeInElement(new TextRange(startOffset, endOffset));
        return positionInExpression + propertyName.length() + 1;
    }

    @NotNull
    private static PsiReferenceBase getIdReferenceBase(XmlAttributeValue xmlAttributeValue, String referencesId, Map<String, XmlAttributeValue> fileIds, Map<String, TypeMatch> typeMatches, PsiClass controllerClass) {
        PsiField controllerField;
        if (controllerClass != null && !"controller".equals(referencesId) && (controllerField = controllerClass.findFieldByName(referencesId, false)) != null) {
            JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef javaFxControllerFieldRef = new JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef(xmlAttributeValue, (PsiMember)controllerField, controllerClass);
            if (javaFxControllerFieldRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getIdReferenceBase"));
            }
            return javaFxControllerFieldRef;
        }
        JavaFxIdReferenceBase javaFxIdReferenceBase = new JavaFxIdReferenceBase(xmlAttributeValue, fileIds, typeMatches, referencesId);
        if (javaFxIdReferenceBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getIdReferenceBase"));
        }
        return javaFxIdReferenceBase;
    }

    private static class JavaFxExpressionReferenceBase
    extends JavaFxPropertyReference<XmlAttributeValue> {
        private final String myFieldName;

        public JavaFxExpressionReferenceBase(@NotNull XmlAttributeValue xmlAttributeValue, PsiClass tagClass, @NotNull String fieldName) {
            if (xmlAttributeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "<init>"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "<init>"));
            }
            super(xmlAttributeValue, tagClass);
            this.myFieldName = fieldName;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)JavaFxPsiUtil.getReadableProperties(this.myPsiClass).get(this.myFieldName);
        }

        @NotNull
        public Object[] getVariants() {
            XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)this.getElement();
            PsiElement declaration = JavaFxPsiUtil.getAttributeDeclaration(xmlAttributeValue);
            PsiType propertyType = JavaFxPsiUtil.getWritablePropertyType(this.myPsiClass, declaration);
            if (propertyType != null) {
                Object[] objectArray = this.collectProperties(propertyType, xmlAttributeValue.getProject());
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        private Object[] collectProperties(@NotNull PsiType propertyType, @NotNull Project project) {
            if (propertyType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyType", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "collectProperties"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "collectProperties"));
            }
            PsiType resolvedType = JavaFxPsiUtil.getWritablePropertyType(propertyType, project);
            ArrayList<LookupElementBuilder> objs = new ArrayList<LookupElementBuilder>();
            Collection<PsiMember> readableProperties = JavaFxPsiUtil.getReadableProperties(this.myPsiClass).values();
            for (PsiMember readableMember : readableProperties) {
                String propertyName;
                PsiType readableType = JavaFxPsiUtil.getReadablePropertyType((PsiElement)readableMember);
                if (readableType == null || !TypeConversionUtil.isAssignable((PsiType)propertyType, (PsiType)readableType) && (resolvedType == null || !TypeConversionUtil.isAssignable((PsiType)resolvedType, (PsiType)readableType)) || (propertyName = PropertyUtil.getPropertyName((PsiMember)readableMember)) == null) continue;
                objs.add(LookupElementBuilder.create((Object)readableMember, (String)propertyName));
            }
            return ArrayUtil.toObjectArray(objs);
        }

        @Override
        @NotNull
        public String getPropertyName() {
            String string = this.myFieldName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "getPropertyName"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            String newPropertyName = JavaFxPsiUtil.getPropertyName(newElementName, this.resolve() instanceof PsiMethod);
            return super.handleElementRename(newPropertyName);
        }
    }

    public static class JavaFxIdReferenceBase
    extends PsiReferenceBase<XmlAttributeValue> {
        private final Map<String, XmlAttributeValue> myFileIds;
        private final Set<String> myAcceptableIds;
        private final Map<String, TypeMatch> myTypeMatches;
        private final String myReferencesId;

        private JavaFxIdReferenceBase(XmlAttributeValue element, Map<String, XmlAttributeValue> fileIds, Set<String> acceptableIds, String referencesId) {
            super((PsiElement)element);
            this.myFileIds = fileIds;
            this.myAcceptableIds = acceptableIds;
            this.myReferencesId = referencesId;
            this.myTypeMatches = Collections.emptyMap();
        }

        public JavaFxIdReferenceBase(XmlAttributeValue xmlAttributeValue, Map<String, XmlAttributeValue> fileIds, Map<String, TypeMatch> typeMatches, String referencesId) {
            super((PsiElement)xmlAttributeValue);
            this.myFileIds = fileIds;
            this.myTypeMatches = typeMatches;
            this.myReferencesId = referencesId;
            this.myAcceptableIds = this.myFileIds.keySet();
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)this.myFileIds.get(this.myReferencesId);
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = this.myAcceptableIds.stream().map(id -> PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)id), (double)TypeMatch.getPriority(this.myTypeMatches.get(id)))).toArray(LookupElement[]::new);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxIdReferenceBase", "getVariants"));
            }
            return objectArray;
        }

        public boolean isBuiltIn() {
            return "controller".equals(this.myReferencesId) || this.myReferencesId.endsWith("Controller");
        }
    }

    private static enum TypeMatch {
        ASSIGNABLE(3.0),
        CONVERTIBLE(2.0),
        UNDEFINED(1.0),
        INCOMPATIBLE(0.0);

        private final double myPriority;

        private TypeMatch(double priority) {
            this.myPriority = priority;
        }

        public static double getPriority(TypeMatch match) {
            return match != null ? match.myPriority : 0.0;
        }

        @NotNull
        public static TypeMatch getMatch(PsiClass valueClass, PsiClass targetPropertyClass, boolean isConvertible) {
            if (valueClass == null || targetPropertyClass == null) {
                TypeMatch typeMatch = UNDEFINED;
                if (typeMatch == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$TypeMatch", "getMatch"));
                }
                return typeMatch;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)valueClass, (PsiClass)targetPropertyClass, (boolean)true)) {
                TypeMatch typeMatch = ASSIGNABLE;
                if (typeMatch == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$TypeMatch", "getMatch"));
                }
                return typeMatch;
            }
            if (isConvertible) {
                TypeMatch typeMatch = CONVERTIBLE;
                if (typeMatch == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$TypeMatch", "getMatch"));
                }
                return typeMatch;
            }
            TypeMatch typeMatch = INCOMPATIBLE;
            if (typeMatch == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$TypeMatch", "getMatch"));
            }
            return typeMatch;
        }
    }
}

