/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.converter;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineFacetConverterProvider
extends ConverterProvider {
    public AppEngineFacetConverterProvider() {
        super("google-app-engine-facet");
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/appengine/converter/AppEngineFacetConverterProvider", "createConverter"));
        }
        ProjectConverter projectConverter = new ProjectConverter(){

            @Nullable
            public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
                return new GoogleAppEngineFacetConversionProcessor();
            }
        };
        if (projectConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/converter/AppEngineFacetConverterProvider", "createConverter"));
        }
        return projectConverter;
    }

    @NotNull
    public String getConversionDescription() {
        if ("Google App Engine facets will be decoupled from Web facets" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/converter/AppEngineFacetConverterProvider", "getConversionDescription"));
        }
        return "Google App Engine facets will be decoupled from Web facets";
    }

    private static class GoogleAppEngineFacetConversionProcessor
    extends ConversionProcessor<ModuleSettings> {
        private GoogleAppEngineFacetConversionProcessor() {
        }

        public boolean isConversionNeeded(ModuleSettings settings) {
            return !GoogleAppEngineFacetConversionProcessor.getAppEngineFacetTags(settings).isEmpty();
        }

        public void process(ModuleSettings settings) throws CannotConvertException {
            List<Element> facetTags = GoogleAppEngineFacetConversionProcessor.getAppEngineFacetTags(settings);
            for (Element tag : facetTags) {
                tag.detach();
            }
            Element facetTag = (Element)ContainerUtil.getFirstItem(facetTags);
            if (facetTag != null) {
                String facetName = facetTag.getAttributeValue("name");
                Element configuration = facetTag.getChild("configuration");
                settings.addFacetElement("google-app-engine", facetName, configuration.clone());
            }
        }

        @NotNull
        private static List<Element> getAppEngineFacetTags(@NotNull ModuleSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/appengine/converter/AppEngineFacetConverterProvider$GoogleAppEngineFacetConversionProcessor", "getAppEngineFacetTags"));
            }
            ArrayList<Element> appEngineFacetTags = new ArrayList<Element>();
            for (Element webFacetTag : settings.getFacetElements("web")) {
                for (Element childFacetTag : webFacetTag.getChildren("facet")) {
                    if (!"google-app-engine".equals(childFacetTag.getAttributeValue("type"))) continue;
                    appEngineFacetTags.add(childFacetTag);
                }
            }
            ArrayList<Element> arrayList = appEngineFacetTags;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/converter/AppEngineFacetConverterProvider$GoogleAppEngineFacetConversionProcessor", "getAppEngineFacetTags"));
            }
            return arrayList;
        }
    }
}

