/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.server.instance;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.server.instance.AppEngineRunConfigurationEditor;
import com.intellij.appengine.server.instance.AppEngineServerInstance;
import com.intellij.appengine.util.AppEngineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.DeploysArtifactsOnStartupOnly;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.execution.DefaultOutputProcessor;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineServerModel
implements ServerModel,
DeploysArtifactsOnStartupOnly {
    private ArtifactPointer myArtifactPointer;
    private int myPort = 8080;
    private String myServerParameters = "";
    private CommonModel myCommonModel;

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        return new AppEngineServerInstance(this.myCommonModel);
    }

    public DeploymentProvider getDeploymentProvider() {
        return null;
    }

    @NotNull
    public String getDefaultUrlForBrowser() {
        String string = "http://" + this.myCommonModel.getHost() + ":" + this.myPort;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/server/instance/AppEngineServerModel", "getDefaultUrlForBrowser"));
        }
        return string;
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new AppEngineRunConfigurationEditor(this.myCommonModel.getProject());
    }

    public OutputProcessor createOutputProcessor(ProcessHandler processHandler, J2EEServerInstance serverInstance) {
        return new DefaultOutputProcessor(processHandler);
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return Collections.singletonList(Pair.create((Object)this.myCommonModel.getHost(), (Object)this.myPort));
    }

    public boolean isResourcesReloadingSupported() {
        return this.myCommonModel.isLocal();
    }

    public List<Artifact> getArtifactsToDeploy() {
        return ContainerUtil.createMaybeSingletonList((Object)this.getArtifact());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Artifact artifact;
        if (this.myArtifactPointer == null || (artifact = this.myArtifactPointer.getArtifact()) == null) {
            throw new RuntimeConfigurationError("Artifact isn't specified");
        }
        AppEngineFacet facet = AppEngineUtil.findAppEngineFacet(this.myCommonModel.getProject(), artifact);
        if (facet == null) {
            throw new RuntimeConfigurationWarning("App Engine facet not found in '" + artifact.getName() + "' artifact");
        }
    }

    public int getDefaultPort() {
        return 8080;
    }

    public void setCommonModel(CommonModel commonModel) {
        this.myCommonModel = commonModel;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getLocalPort() {
        return this.myPort;
    }

    public void readExternal(Element element) throws InvalidDataException {
        AppEngineModelSettings settings = new AppEngineModelSettings();
        XmlSerializer.deserializeInto((Object)settings, (Element)element);
        this.myPort = settings.getPort();
        this.myServerParameters = settings.getServerParameters();
        String artifactName = settings.getArtifact();
        this.myArtifactPointer = artifactName != null ? ArtifactPointerManager.getInstance((Project)this.myCommonModel.getProject()).createPointer(artifactName) : null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        XmlSerializer.serializeInto((Object)new AppEngineModelSettings(this.myPort, this.myArtifactPointer, this.myServerParameters), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    @Nullable
    public Artifact getArtifact() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.getArtifact() : null;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public String getServerParameters() {
        return this.myServerParameters;
    }

    public void setServerParameters(String serverParameters) {
        this.myServerParameters = serverParameters;
    }

    public void setArtifact(@Nullable Artifact artifact) {
        this.myArtifactPointer = artifact != null ? ArtifactPointerManager.getInstance((Project)this.myCommonModel.getProject()).createPointer(artifact) : null;
    }

    public static class AppEngineModelSettings {
        @Tag(value="port")
        private int myPort = 8080;
        @Tag(value="artifact")
        private String myArtifact;
        @Tag(value="server-parameters")
        private String myServerParameters = "";

        public AppEngineModelSettings() {
        }

        public AppEngineModelSettings(int port, ArtifactPointer pointer, String serverParameters) {
            this.myPort = port;
            this.myServerParameters = serverParameters;
            this.myArtifact = pointer != null ? pointer.getArtifactName() : null;
        }

        public int getPort() {
            return this.myPort;
        }

        public void setPort(int port) {
            this.myPort = port;
        }

        public String getArtifact() {
            return this.myArtifact;
        }

        public void setArtifact(String artifact) {
            this.myArtifact = artifact;
        }

        public String getServerParameters() {
            return this.myServerParameters;
        }

        public void setServerParameters(String serverParameters) {
            this.myServerParameters = serverParameters;
        }
    }
}

