/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullUtils;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.Gray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToGrayQuickFix;

public class UseGrayInspection
extends DevKitInspectionBase {
    @Override
    protected PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/UseGrayInspection", "buildInternalVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                ProblemDescriptor descriptor = UseGrayInspection.checkNewExpression(expression, holder.getManager(), isOnTheFly);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
            }
        };
    }

    @Nullable
    private static ProblemDescriptor checkNewExpression(PsiNewExpression expression, InspectionManager manager, boolean isOnTheFly) {
        PsiExpressionList arguments;
        Project project = manager.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass grayClass = facade.findClass(Gray.class.getName(), GlobalSearchScope.allScope((Project)project));
        PsiType type = expression.getType();
        if (type != null && grayClass != null && (arguments = expression.getArgumentList()) != null) {
            Object literal;
            PsiExpression e;
            PsiExpression[] expressions = arguments.getExpressions();
            if (expressions.length == 3 && "java.awt.Color".equals(type.getCanonicalText())) {
                Object blue;
                Object green;
                Object red;
                if (!facade.getResolveHelper().isAccessible((PsiMember)grayClass, (PsiElement)expression, grayClass)) {
                    return null;
                }
                PsiExpression r = expressions[0];
                PsiExpression g = expressions[1];
                PsiExpression b = expressions[2];
                if (r instanceof PsiLiteralExpression && g instanceof PsiLiteralExpression && b instanceof PsiLiteralExpression && NullUtils.notNull((Object[])new Object[]{red = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)r, (boolean)false), green = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)g, (boolean)false), blue = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)b, (boolean)false)})) {
                    try {
                        int rr = Integer.parseInt(red.toString());
                        int gg = Integer.parseInt(green.toString());
                        int bb = Integer.parseInt(blue.toString());
                        if (rr == gg && gg == bb && 0 <= rr && rr < 256) {
                            return manager.createProblemDescriptor((PsiElement)expression, "Convert to Gray._" + rr, (LocalQuickFix)new ConvertToGrayQuickFix(rr), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (expressions.length == 1 && "com.intellij.ui.Gray".equals(type.getCanonicalText()) && (e = expressions[0]) instanceof PsiLiteralExpression && (literal = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)e, (boolean)false)) != null) {
                try {
                    int num = Integer.parseInt(literal.toString());
                    if (0 <= num && num < 256) {
                        return manager.createProblemDescriptor((PsiElement)expression, "Convert to Gray_" + num, (LocalQuickFix)new ConvertToGrayQuickFix(num), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @NotNull
    public String getShortName() {
        if ("InspectionUsingGrayColors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/UseGrayInspection", "getShortName"));
        }
        return "InspectionUsingGrayColors";
    }
}

