/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.components.JBList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtil {
    private static final Key<Boolean> IDEA_PROJECT = Key.create((String)"idea.internal.inspections.enabled");
    private static final String IDE_PROJECT_MARKER_CLASS = JBList.class.getName();

    private PsiUtil() {
    }

    public static boolean isInstantiable(@NotNull PsiClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "org/jetbrains/idea/devkit/util/PsiUtil", "isInstantiable"));
        }
        PsiModifierList modList = cls.getModifierList();
        if (modList == null || cls.isInterface() || modList.hasModifierProperty("abstract") || !PsiUtil.isPublicOrStaticInnerClass(cls)) {
            return false;
        }
        PsiMethod[] constructors = cls.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.getParameterList().getParameters().length != 0 || !constructor.hasModifierProperty("public")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicOrStaticInnerClass(@NotNull PsiClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "org/jetbrains/idea/devkit/util/PsiUtil", "isPublicOrStaticInnerClass"));
        }
        PsiModifierList modifiers = cls.getModifierList();
        if (modifiers == null) {
            return false;
        }
        return modifiers.hasModifierProperty("public") && (cls.getParent() instanceof PsiFile || modifiers.hasModifierProperty("static"));
    }

    @Nullable
    public static String getReturnedLiteral(PsiMethod method, PsiClass cls) {
        PsiExpression value = PsiUtil.getReturnedExpression(method);
        if (value instanceof PsiLiteralExpression) {
            Object str = ((PsiLiteralExpression)value).getValue();
            return str == null ? null : str.toString();
        }
        if (value instanceof PsiMethodCallExpression && PsiUtil.isSimpleClassNameExpression((PsiMethodCallExpression)value)) {
            return cls.getName();
        }
        return null;
    }

    private static boolean isSimpleClassNameExpression(PsiMethodCallExpression expr) {
        String text = expr.getText();
        if (text == null) {
            return false;
        }
        return "getClass().getSimpleName()".equals(text = text.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\t", "").replaceAll("\r", "")) || "this.getClass().getSimpleName()".equals(text);
    }

    @Nullable
    public static PsiExpression getReturnedExpression(PsiMethod method) {
        PsiStatement[] statements;
        PsiCodeBlock body = method.getBody();
        if (body != null && (statements = body.getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            PsiField field;
            PsiElement element;
            PsiExpression value = ((PsiReturnStatement)statements[0]).getReturnValue();
            if (value instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && (field = (PsiField)element).hasModifierProperty("final")) {
                return field.getInitializer();
            }
            return value;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findNearestMethod(String name, @Nullable PsiClass cls) {
        if (cls == null) {
            return null;
        }
        for (PsiMethod method : cls.getMethods()) {
            if (method.getParameterList().getParametersCount() != 0 || !method.getName().equals(name)) continue;
            return method.getModifierList().hasModifierProperty("abstract") ? null : method;
        }
        return PsiUtil.findNearestMethod(name, cls.getSuperClass());
    }

    public static boolean isIdeaProject(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        Boolean flag = (Boolean)project.getUserData(IDEA_PROJECT);
        if (flag == null) {
            flag = PsiUtil.checkIdeaProject(project);
            project.putUserData(IDEA_PROJECT, (Object)flag);
        }
        return flag;
    }

    public static boolean isPluginProject(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass(IDE_PROJECT_MARKER_CLASS, GlobalSearchScope.allScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    private static boolean isIntelliJBasedDir(VirtualFile baseDir) {
        if (baseDir == null) {
            return false;
        }
        for (VirtualFile dir : new VirtualFile[]{baseDir, baseDir.findChild("community")}) {
            if (dir == null || !dir.isDirectory() || dir.findChild("idea.iml") == null && dir.findChild("community-main.iml") == null) continue;
            return true;
        }
        return false;
    }

    public static void markAsIdeaProject(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/util/PsiUtil", "markAsIdeaProject"));
        }
        project.putUserData(IDEA_PROJECT, (Object)value);
    }

    private static boolean checkIdeaProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/util/PsiUtil", "checkIdeaProject"));
        }
        if (!PsiUtil.isIntelliJBasedDir(project.getBaseDir())) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(IDE_PROJECT_MARKER_CLASS, scope) != null;
    }

    @NotNull
    public static <E extends PsiElement> SmartPsiElementPointer<E> createPointer(@NotNull E e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/devkit/util/PsiUtil", "createPointer"));
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)e.getProject()).createSmartPsiElementPointer(e);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/util/PsiUtil", "createPointer"));
        }
        return smartPsiElementPointer;
    }
}

