/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.Language;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageGuesser {
    INSTANCE;

    private NotNullLazyValue<List<EmbeddedTokenTypesProvider>> embeddedTokenTypeProviders = new NotNullLazyValue<List<EmbeddedTokenTypesProvider>>(){

        @NotNull
        protected List<EmbeddedTokenTypesProvider> compute() {
            List<Object> list = Arrays.asList(Extensions.getExtensions((ExtensionPointName)EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser$1", "compute"));
            }
            return list;
        }
    };
    private ClearableLazyValue<List<CodeFenceLanguageProvider>> codeFenceLanguageProviders = new ClearableLazyValue<List<CodeFenceLanguageProvider>>(){

        @NotNull
        protected List<CodeFenceLanguageProvider> compute() {
            List<Object> list = Arrays.asList(Extensions.getExtensions(CodeFenceLanguageProvider.EP_NAME));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser$2", "compute"));
            }
            return list;
        }
    };
    private NotNullLazyValue<Map<String, Language>> langIdToLanguage = new NotNullLazyValue<Map<String, Language>>(){

        @NotNull
        protected Map<String, Language> compute() {
            HashMap result = new HashMap();
            for (Language language : Language.getRegisteredLanguages()) {
                if (language.getID().isEmpty()) continue;
                result.put((Object)language.getID().toLowerCase(Locale.US), (Object)language);
            }
            Language javascriptLanguage = (Language)result.get((Object)"javascript");
            if (javascriptLanguage != null) {
                result.put((Object)"js", (Object)javascriptLanguage);
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser$3", "compute"));
            }
            return hashMap;
        }
    };

    @NotNull
    public Map<String, Language> getLangToLanguageMap() {
        Map<String, Language> map = Collections.unmodifiableMap((Map)this.langIdToLanguage.getValue());
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser", "getLangToLanguageMap"));
        }
        return map;
    }

    @NotNull
    public List<CodeFenceLanguageProvider> getCodeFenceLanguageProviders() {
        List list = (List)this.codeFenceLanguageProviders.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser", "getCodeFenceLanguageProviders"));
        }
        return list;
    }

    public void resetCodeFenceLanguageProviders() {
        this.codeFenceLanguageProviders.drop();
    }

    @Nullable
    public Language guessLanguage(@NotNull String languageName) {
        if (languageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageName", "org/intellij/plugins/markdown/injection/LanguageGuesser", "guessLanguage"));
        }
        for (CodeFenceLanguageProvider provider : (List)this.codeFenceLanguageProviders.getValue()) {
            Language languageByProvider = provider.getLanguageByInfoString(languageName);
            if (languageByProvider == null) continue;
            return languageByProvider;
        }
        Language languageFromMap = (Language)((Map)this.langIdToLanguage.getValue()).get(languageName.toLowerCase(Locale.US));
        if (languageFromMap != null) {
            return languageFromMap;
        }
        for (EmbeddedTokenTypesProvider provider : (List)this.embeddedTokenTypeProviders.getValue()) {
            if (!provider.getName().equalsIgnoreCase(languageName)) continue;
            return provider.getElementType().getLanguage();
        }
        return null;
    }
}

