/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownLinkDefinitionImpl
extends ASTWrapperPsiElement
implements MarkdownPsiElement {
    public MarkdownLinkDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDefinitionImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public PsiElement getLinkLabel() {
        PsiElement label = this.findChildByType(MarkdownElementTypes.LINK_LABEL);
        if (label == null) {
            throw new IllegalStateException("Probably parsing failed. Should have a label");
        }
        PsiElement psiElement = label;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDefinitionImpl", "getLinkLabel"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement getLinkDestination() {
        PsiElement destination = this.findChildByType(MarkdownElementTypes.LINK_DESTINATION);
        if (destination == null) {
            throw new IllegalStateException("Probably parsing failed. Should have a destination");
        }
        PsiElement psiElement = destination;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDefinitionImpl", "getLinkDestination"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getLinkTitle() {
        return this.findChildByType(MarkdownElementTypes.LINK_TITLE);
    }

    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(){

            @Nullable
            public String getPresentableText() {
                if (!MarkdownLinkDefinitionImpl.this.isValid()) {
                    return null;
                }
                return "Def: " + MarkdownLinkDefinitionImpl.this.getLinkLabel().getText() + " \u2192 " + MarkdownLinkDefinitionImpl.this.getLinkDestination().getText();
            }

            @Nullable
            public String getLocationString() {
                if (!MarkdownLinkDefinitionImpl.this.isValid()) {
                    return null;
                }
                PsiElement linkTitle = MarkdownLinkDefinitionImpl.this.getLinkTitle();
                if (linkTitle == null) {
                    return null;
                }
                return linkTitle.getText();
            }
        };
    }

    @Override
    @NotNull
    public List<MarkdownPsiElement> getCompositeChildren() {
        List<MarkdownPsiElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDefinitionImpl", "getCompositeChildren"));
        }
        return list;
    }
}

