/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestinationImpl;
import org.jetbrains.annotations.NotNull;

public class MarkdownReferenceProvider
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(MarkdownLinkDestinationImpl.class).inFile((ElementPattern)PlatformPatterns.psiFile(MarkdownFile.class)), (PsiReferenceProvider)new LinkDestinationReferenceProvider());
    }

    private static class LinkDestinationReferenceProvider
    extends PsiReferenceProvider {
        private LinkDestinationReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider$LinkDestinationReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider$LinkDestinationReferenceProvider", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(element, false, false, true, new PathReferenceProvider[0]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider$LinkDestinationReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    }
}

