/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.annotations.Attribute;
import java.net.URISyntaxException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public final class MarkdownCssSettings {
    public static final MarkdownCssSettings DEFAULT = new MarkdownCssSettings(false);
    public static final MarkdownCssSettings DARCULA = new MarkdownCssSettings(true);
    @Attribute(value="UriEnabled")
    private boolean myUriEnabled;
    @Attribute(value="StylesheetUri")
    @NotNull
    private String myStylesheetUri;
    @Attribute(value="TextEnabled")
    private boolean myTextEnabled;
    @Attribute(value="StylesheetText")
    @NotNull
    private String myStylesheetText;

    private MarkdownCssSettings() {
        this(true, MarkdownCssSettings.getPredefinedCssURI(false), false, "");
    }

    private MarkdownCssSettings(boolean isDarcula) {
        this(true, MarkdownCssSettings.getPredefinedCssURI(isDarcula), false, "");
    }

    public MarkdownCssSettings(boolean uriEnabled, @NotNull String stylesheetUri, boolean textEnabled, @NotNull String stylesheetText) {
        if (stylesheetUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheetUri", "org/intellij/plugins/markdown/settings/MarkdownCssSettings", "<init>"));
        }
        if (stylesheetText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheetText", "org/intellij/plugins/markdown/settings/MarkdownCssSettings", "<init>"));
        }
        this.myUriEnabled = uriEnabled;
        this.myStylesheetUri = stylesheetUri;
        this.myTextEnabled = textEnabled;
        this.myStylesheetText = stylesheetText;
    }

    public boolean isUriEnabled() {
        return this.myUriEnabled;
    }

    @NotNull
    public String getStylesheetUri() {
        String string = this.myStylesheetUri;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssSettings", "getStylesheetUri"));
        }
        return string;
    }

    public boolean isTextEnabled() {
        return this.myTextEnabled;
    }

    @NotNull
    public String getStylesheetText() {
        String string = this.myStylesheetText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssSettings", "getStylesheetText"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkdownCssSettings settings = (MarkdownCssSettings)o;
        if (this.myUriEnabled != settings.myUriEnabled) {
            return false;
        }
        if (this.myTextEnabled != settings.myTextEnabled) {
            return false;
        }
        if (!this.myStylesheetUri.equals(settings.myStylesheetUri)) {
            return false;
        }
        return this.myStylesheetText.equals(settings.myStylesheetText);
    }

    @NotNull
    public static MarkdownCssSettings getDefaultCssSettings(boolean isDarcula) {
        MarkdownCssSettings markdownCssSettings = isDarcula ? DARCULA : DEFAULT;
        if (markdownCssSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssSettings", "getDefaultCssSettings"));
        }
        return markdownCssSettings;
    }

    @NotNull
    private static String getPredefinedCssURI(boolean isDarcula) {
        String string;
        String fileName = isDarcula ? "darcula.css" : "default.css";
        try {
            URL resource = MarkdownCssSettings.class.getResource(fileName);
            string = resource != null ? resource.toURI().toString() : "";
        }
        catch (URISyntaxException e) {
            Logger.getInstance(MarkdownCssSettings.class).error((Throwable)e);
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssSettings", "getPredefinedCssURI"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssSettings", "getPredefinedCssURI"));
        }
        return string;
    }

    public int hashCode() {
        int result = this.myUriEnabled ? 1 : 0;
        result = 31 * result + this.myStylesheetUri.hashCode();
        result = 31 * result + (this.myTextEnabled ? 1 : 0);
        result = 31 * result + this.myStylesheetText.hashCode();
        return result;
    }

    public static interface Holder {
        public void setMarkdownCssSettings(@NotNull MarkdownCssSettings var1);

        @NotNull
        public MarkdownCssSettings getMarkdownCssSettings();
    }
}

