/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownCssSettingsForm
implements MarkdownCssSettings.Holder,
Disposable {
    private JPanel myMainPanel;
    private JBCheckBox myCssFromURIEnabled;
    private JTextField myCssURI;
    private JBCheckBox myApplyCustomCssText;
    private JPanel myEditorPanel;
    @NotNull
    private String myCssText = "";
    @Nullable
    private Editor myEditor;
    @NotNull
    private final ActionListener myUpdateListener;

    public MarkdownCssSettingsForm() {
        this.$$$setupUI$$$();
        this.myUpdateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownCssSettingsForm.this.myCssURI.setEnabled(MarkdownCssSettingsForm.this.myCssFromURIEnabled.isSelected());
                if (MarkdownCssSettingsForm.this.myEditor != null && !MarkdownCssSettingsForm.this.myEditor.isDisposed()) {
                    boolean canEditCss = MarkdownCssSettingsForm.this.myApplyCustomCssText.isSelected();
                    MarkdownCssSettingsForm.this.myEditor.getDocument().setReadOnly(!canEditCss);
                    MarkdownCssSettingsForm.this.myEditor.getSettings().setCaretRowShown(canEditCss);
                    Color baseColor = MarkdownCssSettingsForm.this.myEditor.getColorsScheme().getDefaultBackground();
                    if (canEditCss) {
                        ((EditorEx)MarkdownCssSettingsForm.this.myEditor).setBackgroundColor(baseColor);
                    } else {
                        ((EditorEx)MarkdownCssSettingsForm.this.myEditor).setBackgroundColor(ColorUtil.isDark((Color)baseColor) ? ColorUtil.brighter((Color)baseColor, (int)1) : ColorUtil.darker((Color)baseColor, (int)1));
                    }
                }
            }
        };
        this.myCssFromURIEnabled.addActionListener(this.myUpdateListener);
        this.myApplyCustomCssText.addActionListener(this.myUpdateListener);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myEditorPanel = new JPanel(new BorderLayout());
        this.myEditor = MarkdownCssSettingsForm.createEditor();
        this.myEditorPanel.add((Component)this.myEditor.getComponent(), "Center");
    }

    @NotNull
    private static Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        MarkdownCssSettingsForm.fillEditorSettings(editor.getSettings());
        MarkdownCssSettingsForm.setHighlighting(editor);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssSettingsForm", "createEditor"));
        }
        return editorEx;
    }

    private static void setHighlighting(EditorEx editor) {
        FileType cssFileType = FileTypeManager.getInstance().getFileTypeByExtension("css");
        if (cssFileType == UnknownFileType.INSTANCE) {
            return;
        }
        EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((FileType)cssFileType, (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), null);
        editor.setHighlighter(editorHighlighter);
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(true);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(1);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
    }

    @Override
    public void setMarkdownCssSettings(@NotNull MarkdownCssSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/settings/MarkdownCssSettingsForm", "setMarkdownCssSettings"));
        }
        this.myCssFromURIEnabled.setSelected(settings.isUriEnabled());
        this.myCssURI.setText(settings.getStylesheetUri());
        this.myApplyCustomCssText.setSelected(settings.isTextEnabled());
        this.myCssText = settings.getStylesheetText();
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.myEditor.getDocument().setText((CharSequence)this.myCssText));
        }
        this.myUpdateListener.actionPerformed(null);
    }

    @Override
    @NotNull
    public MarkdownCssSettings getMarkdownCssSettings() {
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            this.myCssText = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return MarkdownCssSettingsForm.this.myEditor.getDocument().getText();
                }
            });
        }
        MarkdownCssSettings markdownCssSettings = new MarkdownCssSettings(this.myCssFromURIEnabled.isSelected(), this.myCssURI.getText(), this.myApplyCustomCssText.isSelected(), this.myCssText);
        if (markdownCssSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssSettingsForm", "getMarkdownCssSettings"));
        }
        return markdownCssSettings;
    }

    public void dispose() {
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }
        this.myEditor = null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCssURI = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("settings.markdown.css.uri.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 1));
        this.myCssFromURIEnabled = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("settings.markdown.css.enable.uri"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myApplyCustomCssText = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("settings.markdown.css.enable.inline"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myEditorPanel;
        ((Component)jPanel2).setBackground(new Color(-1118482));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(150, 150), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

