/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import javax.swing.UIManager;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.jetbrains.annotations.Nullable;

class MarkdownLAFListener
implements LafManagerListener {
    private boolean isLastLAFWasDarcula = MarkdownLAFListener.isDarcula(LafManager.getInstance().getCurrentLookAndFeel());

    MarkdownLAFListener() {
    }

    public void lookAndFeelChanged(LafManager source) {
        UIManager.LookAndFeelInfo newLookAndFeel = source.getCurrentLookAndFeel();
        boolean isNewLookAndFeelDarcula = MarkdownLAFListener.isDarcula(newLookAndFeel);
        if (isNewLookAndFeelDarcula == this.isLastLAFWasDarcula) {
            return;
        }
        this.updateCssSettingsForced(isNewLookAndFeelDarcula);
    }

    public void updateCssSettingsForced(boolean isDarcula) {
        MarkdownCssSettings currentCssSettings = MarkdownApplicationSettings.getInstance().getMarkdownCssSettings();
        MarkdownApplicationSettings.getInstance().setMarkdownCssSettings(new MarkdownCssSettings(currentCssSettings.isUriEnabled(), MarkdownCssSettings.getDefaultCssSettings(isDarcula).getStylesheetUri(), currentCssSettings.isTextEnabled(), currentCssSettings.getStylesheetText()));
        this.isLastLAFWasDarcula = isDarcula;
    }

    public static boolean isDarcula(@Nullable UIManager.LookAndFeelInfo laf) {
        if (laf == null) {
            return false;
        }
        return laf.getName().contains("Darcula");
    }
}

