/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;

public class MarkdownPreviewSettingsForm
implements MarkdownPreviewSettings.Holder {
    private Object myLastItem;
    private ComboBox myPreviewProvider;
    private ComboBox myDefaultSplitLayout;
    private JPanel myMainPanel;
    private JBCheckBox myUseGrayscaleRenderingForJBCheckBox;
    private EnumComboBoxModel<SplitFileEditor.SplitEditorLayout> mySplitLayoutModel;
    private CollectionComboBoxModel<MarkdownHtmlPanelProvider.ProviderInfo> myPreviewPanelModel;

    public MarkdownPreviewSettingsForm() {
        this.$$$setupUI$$$();
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        List providerInfos = ContainerUtil.mapNotNull((Object[])MarkdownHtmlPanelProvider.getProviders(), provider -> {
            if (provider.isAvailable() == MarkdownHtmlPanelProvider.AvailabilityInfo.UNAVAILABLE) {
                return null;
            }
            return provider.getProviderInfo();
        });
        this.myPreviewPanelModel = new CollectionComboBoxModel(providerInfos, providerInfos.get(0));
        this.myPreviewProvider = new ComboBox(this.myPreviewPanelModel);
        this.mySplitLayoutModel = new EnumComboBoxModel(SplitFileEditor.SplitEditorLayout.class);
        this.myDefaultSplitLayout = new ComboBox(this.mySplitLayoutModel);
        this.myLastItem = this.myPreviewProvider.getSelectedItem();
        this.myPreviewProvider.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() != 1 || !(item instanceof MarkdownHtmlPanelProvider.ProviderInfo)) {
                    return;
                }
                MarkdownHtmlPanelProvider provider = MarkdownHtmlPanelProvider.createFromInfo((MarkdownHtmlPanelProvider.ProviderInfo)item);
                MarkdownHtmlPanelProvider.AvailabilityInfo availability = provider.isAvailable();
                if (!availability.checkAvailability(MarkdownPreviewSettingsForm.this.myMainPanel)) {
                    MarkdownPreviewSettingsForm.this.myPreviewProvider.setSelectedItem(MarkdownPreviewSettingsForm.this.myLastItem);
                } else {
                    MarkdownPreviewSettingsForm.this.myLastItem = item;
                    MarkdownPreviewSettingsForm.this.updateUseGrayscaleEnabled();
                }
            }
        });
    }

    private void updateUseGrayscaleEnabled() {
        MarkdownHtmlPanelProvider.ProviderInfo selected = (MarkdownHtmlPanelProvider.ProviderInfo)this.myPreviewPanelModel.getSelected();
        this.myUseGrayscaleRenderingForJBCheckBox.setEnabled(selected != null && selected.getClassName().contains("JavaFxHtmlPanelProvider"));
    }

    @Override
    public void setMarkdownPreviewSettings(@NotNull MarkdownPreviewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/settings/MarkdownPreviewSettingsForm", "setMarkdownPreviewSettings"));
        }
        if (this.myPreviewPanelModel.contains((Object)settings.getHtmlPanelProviderInfo())) {
            this.myPreviewPanelModel.setSelectedItem((Object)settings.getHtmlPanelProviderInfo());
        }
        this.mySplitLayoutModel.setSelectedItem((Enum)settings.getSplitEditorLayout());
        this.myUseGrayscaleRenderingForJBCheckBox.setSelected(settings.isUseGrayscaleRendering());
        this.updateUseGrayscaleEnabled();
    }

    @Override
    @NotNull
    public MarkdownPreviewSettings getMarkdownPreviewSettings() {
        if (this.myPreviewPanelModel.getSelected() == null) {
            throw new IllegalStateException("Should be selected always");
        }
        MarkdownPreviewSettings markdownPreviewSettings = new MarkdownPreviewSettings((SplitFileEditor.SplitEditorLayout)this.mySplitLayoutModel.getSelectedItem(), (MarkdownHtmlPanelProvider.ProviderInfo)this.myPreviewPanelModel.getSelected(), this.myUseGrayscaleRenderingForJBCheckBox.isSelected());
        if (markdownPreviewSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownPreviewSettingsForm", "getMarkdownPreviewSettings"));
        }
        return markdownPreviewSettings;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ComboBox comboBox = this.myPreviewProvider;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Preview browser:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Default editor layout:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox2 = this.myDefaultSplitLayout;
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myUseGrayscaleRenderingForJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/intellij/plugins/markdown/bundle/MarkdownBundle").getString("settings.markdown.preview.use.grayscale"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

