/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.structureView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkdownStructureElement
extends PsiTreeElementBase<PsiElement>
implements SortableTreeElement,
LocationPresentation,
Queryable {
    static final TokenSet PRESENTABLE_TYPES = MarkdownTokenTypeSets.HEADERS;
    static final TokenSet TRANSPARENT_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{MarkdownTokenTypeSets.MARKDOWN_FILE, MarkdownTokenTypeSets.UNORDERED_LIST, MarkdownTokenTypeSets.ORDERED_LIST, MarkdownTokenTypeSets.LIST_ITEM, MarkdownTokenTypeSets.BLOCK_QUOTE});
    private static final ItemPresentation DUMMY_PRESENTATION = new MarkdownBasePresentation(){

        @Nullable
        public String getPresentableText() {
            return null;
        }

        @Nullable
        public String getLocationString() {
            return null;
        }
    };
    private static final List<TokenSet> HEADER_ORDER = Arrays.asList(TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE_ELEMENT_TYPE}), MarkdownTokenTypeSets.HEADER_LEVEL_1_SET, MarkdownTokenTypeSets.HEADER_LEVEL_2_SET, MarkdownTokenTypeSets.HEADER_LEVEL_3_SET, MarkdownTokenTypeSets.HEADER_LEVEL_4_SET, MarkdownTokenTypeSets.HEADER_LEVEL_5_SET, MarkdownTokenTypeSets.HEADER_LEVEL_6_SET);

    MarkdownStructureElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "<init>"));
        }
        super(element);
    }

    public boolean canNavigate() {
        return this.getElement() instanceof NavigationItem && ((NavigationItem)this.getElement()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getElement() instanceof NavigationItem && ((NavigationItem)this.getElement()).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        if (this.getElement() instanceof NavigationItem) {
            ((NavigationItem)this.getElement()).navigate(requestFocus);
        }
    }

    @NotNull
    public String getAlphaSortKey() {
        String string = StringUtil.notNullize(this.getElement() instanceof NavigationItem ? ((NavigationItem)this.getElement()).getName() : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getAlphaSortKey"));
        }
        return string;
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    @Nullable
    public String getPresentableText() {
        PsiElement tag = this.getElement();
        if (tag == null) {
            return IdeBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
        }
        return this.getPresentation().getPresentableText();
    }

    public String getLocationString() {
        return this.getPresentation().getLocationString();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresent;
        if (this.getElement() instanceof PsiFileImpl) {
            ItemPresentation filePresent = ((PsiFileImpl)this.getElement()).getPresentation();
            ItemPresentation itemPresentation = filePresent != null ? filePresent : DUMMY_PRESENTATION;
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getPresentation"));
            }
            return itemPresentation;
        }
        if (this.getElement() instanceof NavigationItem && (itemPresent = ((NavigationItem)this.getElement()).getPresentation()) != null) {
            ItemPresentation itemPresentation = itemPresent;
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getPresentation"));
            }
            return itemPresentation;
        }
        ItemPresentation itemPresentation = DUMMY_PRESENTATION;
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getPresentation"));
        }
        return itemPresentation;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        PsiElement structureContainer;
        ArrayList<StructureViewTreeElement> childrenElements = new ArrayList<StructureViewTreeElement>();
        PsiElement myElement = this.getElement();
        if (myElement == null) {
            ArrayList<StructureViewTreeElement> arrayList = childrenElements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getChildrenBase"));
            }
            return arrayList;
        }
        PsiElement psiElement = structureContainer = myElement instanceof MarkdownFile ? myElement.getFirstChild() : MarkdownStructureElement.getParentOfType(myElement, TRANSPARENT_CONTAINERS);
        if (structureContainer == null) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getChildrenBase"));
            }
            return list;
        }
        MarkdownHeaderImpl currentHeader = myElement instanceof MarkdownHeaderImpl ? (MarkdownHeaderImpl)myElement : null;
        MarkdownStructureElement.processContainer(structureContainer, (PsiElement)currentHeader, currentHeader, (Consumer<? super PsiElement>)((Consumer)element -> childrenElements.add((StructureViewTreeElement)new MarkdownStructureElement((PsiElement)element))));
        ArrayList<StructureViewTreeElement> arrayList = childrenElements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getChildrenBase"));
        }
        return arrayList;
    }

    private static void processContainer(@NotNull PsiElement container, @Nullable PsiElement sameLevelRestriction, @Nullable MarkdownPsiElement from, @NotNull Consumer<? super PsiElement> resultConsumer) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "processContainer"));
        }
        if (resultConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "processContainer"));
        }
        PsiElement maxContentLevel = null;
        for (PsiElement nextSibling = from == null ? container.getFirstChild() : from.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (TRANSPARENT_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)nextSibling)) && maxContentLevel == null) {
                MarkdownStructureElement.processContainer(nextSibling, null, null, resultConsumer);
                continue;
            }
            if (!(nextSibling instanceof MarkdownHeaderImpl)) continue;
            if (sameLevelRestriction != null && MarkdownStructureElement.isSameLevelOrHigher(nextSibling, sameLevelRestriction)) break;
            if (maxContentLevel != null && !MarkdownStructureElement.isSameLevelOrHigher(nextSibling, maxContentLevel)) continue;
            maxContentLevel = nextSibling;
            IElementType type = nextSibling.getNode().getElementType();
            if (!PRESENTABLE_TYPES.contains(type)) continue;
            resultConsumer.consume((Object)nextSibling);
        }
    }

    private static boolean isSameLevelOrHigher(@NotNull PsiElement psiA, @NotNull PsiElement psiB) {
        if (psiA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiA", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "isSameLevelOrHigher"));
        }
        if (psiB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiB", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "isSameLevelOrHigher"));
        }
        IElementType typeA = psiA.getNode().getElementType();
        IElementType typeB = psiB.getNode().getElementType();
        return MarkdownStructureElement.headerLevel(typeA) <= MarkdownStructureElement.headerLevel(typeB);
    }

    private static int headerLevel(@NotNull IElementType curLevelType) {
        if (curLevelType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curLevelType", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "headerLevel"));
        }
        for (int i = 0; i < HEADER_ORDER.size(); ++i) {
            if (!HEADER_ORDER.get(i).contains(curLevelType)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    private static PsiElement getParentOfType(@NotNull PsiElement myElement, @NotNull TokenSet types) {
        if (myElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myElement", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getParentOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getParentOfType"));
        }
        ASTNode parentNode = TreeUtil.findParent((ASTNode)myElement.getNode(), (TokenSet)types);
        return parentNode == null ? null : parentNode.getPsi();
    }

    @NotNull
    public String getLocationPrefix() {
        if (" " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getLocationPrefix"));
        }
        return " ";
    }

    @NotNull
    public String getLocationSuffix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getLocationSuffix"));
        }
        return "";
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "putInfo"));
        }
        info.put("text", this.getPresentableText());
        if (!(this.getElement() instanceof PsiFileImpl)) {
            info.put("location", this.getLocationString());
        }
    }
}

