/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.ui.actions.styling.BaseToggleStateAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleCodeSpanAction
extends BaseToggleStateAction {
    @Override
    @NotNull
    protected String getBoundString(@NotNull CharSequence text, int selectionStart, int selectionEnd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/markdown/ui/actions/styling/ToggleCodeSpanAction", "getBoundString"));
        }
        int maxBacktickSequenceSeen = 0;
        int curBacktickSequence = 0;
        for (int i = selectionStart; i < selectionEnd; ++i) {
            if (text.charAt(i) != '`') {
                curBacktickSequence = 0;
                continue;
            }
            maxBacktickSequenceSeen = Math.max(maxBacktickSequenceSeen, ++curBacktickSequence);
        }
        String string = StringUtil.repeat((String)"`", (int)(maxBacktickSequenceSeen + 1));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/actions/styling/ToggleCodeSpanAction", "getBoundString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getExistingBoundString(@NotNull CharSequence text, int startOffset) {
        int to;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/markdown/ui/actions/styling/ToggleCodeSpanAction", "getExistingBoundString"));
        }
        for (to = startOffset; to < text.length() && text.charAt(to) == '`'; ++to) {
        }
        return text.subSequence(startOffset, to).toString();
    }

    @Override
    protected boolean shouldMoveToWordBounds() {
        return false;
    }

    @Override
    @NotNull
    protected IElementType getTargetNodeType() {
        IElementType iElementType = MarkdownElementTypes.CODE_SPAN;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/actions/styling/ToggleCodeSpanAction", "getTargetNodeType"));
        }
        return iElementType;
    }
}

