/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.split;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.ui.split.SplitEditorToolbar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SplitFileEditor<E1 extends FileEditor, E2 extends FileEditor>
extends UserDataHolderBase
implements FileEditor {
    public static final Key<SplitFileEditor> PARENT_SPLIT_KEY = Key.create((String)"parentSplit");
    private static final String MY_PROPORTION_KEY = "SplitFileEditor.Proportion";
    @NotNull
    protected final E1 myMainEditor;
    @NotNull
    protected final E2 mySecondEditor;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private SplitEditorLayout mySplitEditorLayout;
    @NotNull
    private final MyListenersMultimap myListenersGenerator;
    private SplitEditorToolbar myToolbarWrapper;

    public SplitFileEditor(@NotNull E1 mainEditor, @NotNull E2 secondEditor) {
        if (mainEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainEditor", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "<init>"));
        }
        if (secondEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondEditor", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "<init>"));
        }
        this.mySplitEditorLayout = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().getSplitEditorLayout();
        this.myListenersGenerator = new MyListenersMultimap();
        this.myMainEditor = mainEditor;
        this.mySecondEditor = secondEditor;
        this.myComponent = this.createComponent();
        if (this.myMainEditor instanceof TextEditor) {
            this.myMainEditor.putUserData(PARENT_SPLIT_KEY, (Object)this);
        }
        if (this.mySecondEditor instanceof TextEditor) {
            this.mySecondEditor.putUserData(PARENT_SPLIT_KEY, (Object)this);
        }
    }

    @NotNull
    private JComponent createComponent() {
        JBSplitter splitter = new JBSplitter(false, 0.5f, 0.15f, 0.85f);
        splitter.setSplitterProportionKey(MY_PROPORTION_KEY);
        splitter.setFirstComponent(this.myMainEditor.getComponent());
        splitter.setSecondComponent(this.mySecondEditor.getComponent());
        this.myToolbarWrapper = new SplitEditorToolbar((JComponent)splitter);
        if (this.myMainEditor instanceof TextEditor) {
            this.myToolbarWrapper.addGutterToTrack((EditorGutterComponentEx)((TextEditor)this.myMainEditor).getEditor().getGutter());
        }
        if (this.mySecondEditor instanceof TextEditor) {
            this.myToolbarWrapper.addGutterToTrack((EditorGutterComponentEx)((TextEditor)this.mySecondEditor).getEditor().getGutter());
        }
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.myToolbarWrapper, "North");
        result.add((Component)splitter, "Center");
        this.adjustEditorsVisibility();
        JPanel jPanel = result;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "createComponent"));
        }
        return jPanel;
    }

    public void triggerLayoutChange() {
        int oldValue = this.mySplitEditorLayout.ordinal();
        int N = SplitEditorLayout.values().length;
        int newValue = (oldValue + N - 1) % N;
        this.triggerLayoutChange(SplitEditorLayout.values()[newValue]);
    }

    public void triggerLayoutChange(@NotNull SplitEditorLayout newLayout) {
        if (newLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLayout", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "triggerLayoutChange"));
        }
        if (this.mySplitEditorLayout == newLayout) {
            return;
        }
        this.mySplitEditorLayout = newLayout;
        this.invalidateLayout();
    }

    @NotNull
    public SplitEditorLayout getCurrentEditorLayout() {
        SplitEditorLayout splitEditorLayout = this.mySplitEditorLayout;
        if (splitEditorLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "getCurrentEditorLayout"));
        }
        return splitEditorLayout;
    }

    private void invalidateLayout() {
        this.adjustEditorsVisibility();
        this.myToolbarWrapper.refresh();
        this.myComponent.repaint();
        JComponent focusComponent = this.getPreferredFocusedComponent();
        if (focusComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusComponent).requestFocus((Component)focusComponent, true);
        }
    }

    private void adjustEditorsVisibility() {
        this.myMainEditor.getComponent().setVisible(this.mySplitEditorLayout.showFirst);
        this.mySecondEditor.getComponent().setVisible(this.mySplitEditorLayout.showSecond);
    }

    @NotNull
    public E1 getMainEditor() {
        E1 E1 = this.myMainEditor;
        if (E1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "getMainEditor"));
        }
        return E1;
    }

    @NotNull
    public E2 getSecondEditor() {
        E2 E2 = this.mySecondEditor;
        if (E2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "getSecondEditor"));
        }
        return E2;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myMainEditor.getPreferredFocusedComponent();
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "getState"));
        }
        MyFileEditorState myFileEditorState = new MyFileEditorState(this.mySplitEditorLayout.name(), this.myMainEditor.getState(level), this.mySecondEditor.getState(level));
        if (myFileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "getState"));
        }
        return myFileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "setState"));
        }
        if (state instanceof MyFileEditorState) {
            MyFileEditorState compositeState = (MyFileEditorState)state;
            if (compositeState.getFirstState() != null) {
                this.myMainEditor.setState(compositeState.getFirstState());
            }
            if (compositeState.getSecondState() != null) {
                this.mySecondEditor.setState(compositeState.getSecondState());
            }
            if (compositeState.getSplitLayout() != null) {
                this.mySplitEditorLayout = SplitEditorLayout.valueOf(compositeState.getSplitLayout());
                this.invalidateLayout();
            }
        }
    }

    public boolean isModified() {
        return this.myMainEditor.isModified() || this.mySecondEditor.isModified();
    }

    public boolean isValid() {
        return this.myMainEditor.isValid() && this.mySecondEditor.isValid();
    }

    public void selectNotify() {
        this.myMainEditor.selectNotify();
        this.mySecondEditor.selectNotify();
    }

    public void deselectNotify() {
        this.myMainEditor.deselectNotify();
        this.mySecondEditor.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "addPropertyChangeListener"));
        }
        this.myMainEditor.addPropertyChangeListener(listener);
        this.mySecondEditor.addPropertyChangeListener(listener);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.addListenerAndGetDelegate(listener);
        this.myMainEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
        this.mySecondEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/intellij/plugins/markdown/ui/split/SplitFileEditor", "removePropertyChangeListener"));
        }
        this.myMainEditor.removePropertyChangeListener(listener);
        this.mySecondEditor.removePropertyChangeListener(listener);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.removeListenerAndGetDelegate(listener);
        if (delegate != null) {
            this.myMainEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
            this.mySecondEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myMainEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myMainEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myMainEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose(this.myMainEditor);
        Disposer.dispose(this.mySecondEditor);
    }

    public static enum SplitEditorLayout {
        FIRST(true, false, MarkdownBundle.message("markdown.layout.editor.only", new Object[0])),
        SECOND(false, true, MarkdownBundle.message("markdown.layout.preview.only", new Object[0])),
        SPLIT(true, true, MarkdownBundle.message("markdown.layout.editor.and.preview", new Object[0]));

        public final boolean showFirst;
        public final boolean showSecond;
        public final String presentationName;

        private SplitEditorLayout(boolean showFirst, boolean showSecond, String presentationName) {
            this.showFirst = showFirst;
            this.showSecond = showSecond;
            this.presentationName = presentationName;
        }

        public String toString() {
            return this.presentationName;
        }
    }

    private class MyListenersMultimap {
        private final Map<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>> myMap = new HashMap<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>>();

        private MyListenersMultimap() {
        }

        @NotNull
        public DoublingEventListenerDelegate addListenerAndGetDelegate(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/intellij/plugins/markdown/ui/split/SplitFileEditor$MyListenersMultimap", "addListenerAndGetDelegate"));
            }
            if (!this.myMap.containsKey(listener)) {
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)1, (Object)new DoublingEventListenerDelegate(listener)));
            } else {
                Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener);
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() + 1), (Object)oldPair.getSecond()));
            }
            DoublingEventListenerDelegate doublingEventListenerDelegate = (DoublingEventListenerDelegate)this.myMap.get(listener).getSecond();
            if (doublingEventListenerDelegate == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitFileEditor$MyListenersMultimap", "addListenerAndGetDelegate"));
            }
            return doublingEventListenerDelegate;
        }

        @Nullable
        public DoublingEventListenerDelegate removeListenerAndGetDelegate(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/intellij/plugins/markdown/ui/split/SplitFileEditor$MyListenersMultimap", "removeListenerAndGetDelegate"));
            }
            Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener);
            if (oldPair == null) {
                return null;
            }
            if ((Integer)oldPair.getFirst() == 1) {
                this.myMap.remove(listener);
            } else {
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() - 1), (Object)oldPair.getSecond()));
            }
            return (DoublingEventListenerDelegate)oldPair.getSecond();
        }
    }

    private class DoublingEventListenerDelegate
    implements PropertyChangeListener {
        @NotNull
        private final PropertyChangeListener myDelegate;

        private DoublingEventListenerDelegate(PropertyChangeListener delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/intellij/plugins/markdown/ui/split/SplitFileEditor$DoublingEventListenerDelegate", "<init>"));
            }
            this.myDelegate = delegate;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myDelegate.propertyChange(new PropertyChangeEvent((Object)SplitFileEditor.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }
    }

    static class MyFileEditorState
    implements FileEditorState {
        @Nullable
        private final String mySplitLayout;
        @Nullable
        private final FileEditorState myFirstState;
        @Nullable
        private final FileEditorState mySecondState;

        public MyFileEditorState(@Nullable String splitLayout, @Nullable FileEditorState firstState, @Nullable FileEditorState secondState) {
            this.mySplitLayout = splitLayout;
            this.myFirstState = firstState;
            this.mySecondState = secondState;
        }

        @Nullable
        public String getSplitLayout() {
            return this.mySplitLayout;
        }

        @Nullable
        public FileEditorState getFirstState() {
            return this.myFirstState;
        }

        @Nullable
        public FileEditorState getSecondState() {
            return this.mySecondState;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return !(!(otherState instanceof MyFileEditorState) || this.myFirstState != null && !this.myFirstState.canBeMergedWith(((MyFileEditorState)otherState).myFirstState, level) || this.mySecondState != null && !this.mySecondState.canBeMergedWith(((MyFileEditorState)otherState).mySecondState, level));
        }
    }
}

