/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextUtil;

public class ConstExprent
extends Exprent {
    private static final Map<Integer, String> CHAR_ESCAPES = new HashMap<Integer, String>();
    private VarType constType;
    private final Object value;
    private final boolean boolPermitted;

    public ConstExprent(int val, boolean boolPermitted, Set<Integer> bytecodeOffsets) {
        this(ConstExprent.guessType(val, boolPermitted), new Integer(val), boolPermitted, bytecodeOffsets);
    }

    public ConstExprent(VarType constType, Object value, Set<Integer> bytecodeOffsets) {
        this(constType, value, false, bytecodeOffsets);
    }

    private ConstExprent(VarType constType, Object value, boolean boolPermitted, Set<Integer> bytecodeOffsets) {
        super(3);
        this.constType = constType;
        this.value = value;
        this.boolPermitted = boolPermitted;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private static VarType guessType(int val, boolean boolPermitted) {
        if (boolPermitted) {
            VarType constType = VarType.VARTYPE_BOOLEAN;
            if (val != 0 && val != 1) {
                constType = constType.copy(true);
            }
            return constType;
        }
        if (0 <= val && val <= 127) {
            return VarType.VARTYPE_BYTECHAR;
        }
        if (-128 <= val && val <= 127) {
            return VarType.VARTYPE_BYTE;
        }
        if (0 <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORTCHAR;
        }
        if (Short.MIN_VALUE <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORT;
        }
        if (0 <= val && val <= 65535) {
            return VarType.VARTYPE_CHAR;
        }
        return VarType.VARTYPE_INT;
    }

    @Override
    public Exprent copy() {
        return new ConstExprent(this.constType, this.value, (Set<Integer>)this.bytecode);
    }

    @Override
    public VarType getExprType() {
        return this.constType;
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        boolean literal = DecompilerContext.getOption("lit");
        boolean ascii = DecompilerContext.getOption("asc");
        tracer.addMapping(this.bytecode);
        if (this.constType.type != 13 && this.value == null) {
            return new TextBuffer(ExprProcessor.getCastTypeName(this.constType));
        }
        switch (this.constType.type) {
            case 7: {
                return new TextBuffer(Boolean.toString((Integer)this.value != 0));
            }
            case 1: {
                Integer val = (Integer)this.value;
                String ret = CHAR_ESCAPES.get(val);
                if (ret == null) {
                    char c = (char)val.intValue();
                    ret = c >= ' ' && c < '\u007f' || !ascii && TextUtil.isPrintableUnicode(c) ? String.valueOf(c) : TextUtil.charToUnicodeLiteral(c);
                }
                return new TextBuffer(ret).enclose("'", "'");
            }
            case 0: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                int intVal = (Integer)this.value;
                if (!literal) {
                    if (intVal == Integer.MAX_VALUE) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (intVal == Integer.MIN_VALUE) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                }
                return new TextBuffer(this.value.toString());
            }
            case 5: {
                long longVal = (Long)this.value;
                if (!literal) {
                    if (longVal == Long.MAX_VALUE) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (longVal == Long.MIN_VALUE) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                }
                return new TextBuffer(this.value.toString()).append('L');
            }
            case 3: {
                float floatVal = ((Float)this.value).floatValue();
                if (!literal) {
                    if (Float.isNaN(floatVal)) {
                        return new FieldExprent("NaN", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (floatVal == Float.POSITIVE_INFINITY) {
                        return new FieldExprent("POSITIVE_INFINITY", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (floatVal == Float.NEGATIVE_INFINITY) {
                        return new FieldExprent("NEGATIVE_INFINITY", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (floatVal == Float.MAX_VALUE) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (floatVal == Float.MIN_VALUE) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                } else {
                    if (Float.isNaN(floatVal)) {
                        return new TextBuffer("0.0F / 0.0");
                    }
                    if (floatVal == Float.POSITIVE_INFINITY) {
                        return new TextBuffer("1.0F / 0.0");
                    }
                    if (floatVal == Float.NEGATIVE_INFINITY) {
                        return new TextBuffer("-1.0F / 0.0");
                    }
                }
                return new TextBuffer(this.value.toString()).append('F');
            }
            case 2: {
                double doubleVal = (Double)this.value;
                if (!literal) {
                    if (Double.isNaN(doubleVal)) {
                        return new FieldExprent("NaN", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.POSITIVE_INFINITY) {
                        return new FieldExprent("POSITIVE_INFINITY", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.NEGATIVE_INFINITY) {
                        return new FieldExprent("NEGATIVE_INFINITY", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MAX_VALUE) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MIN_VALUE) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                } else {
                    if (Double.isNaN(doubleVal)) {
                        return new TextBuffer("0.0D / 0.0");
                    }
                    if (doubleVal == Double.POSITIVE_INFINITY) {
                        return new TextBuffer("1.0D / 0.0");
                    }
                    if (doubleVal == Double.NEGATIVE_INFINITY) {
                        return new TextBuffer("-1.0D / 0.0");
                    }
                }
                return new TextBuffer(this.value.toString()).append('D');
            }
            case 13: {
                return new TextBuffer("null");
            }
            case 8: {
                String stringVal;
                if (this.constType.equals(VarType.VARTYPE_STRING)) {
                    return new TextBuffer(ConstExprent.convertStringToJava(this.value.toString(), ascii)).enclose("\"", "\"");
                }
                if (!this.constType.equals(VarType.VARTYPE_CLASS)) break;
                VarType type = new VarType(stringVal, !(stringVal = this.value.toString()).startsWith("["));
                return new TextBuffer(ExprProcessor.getCastTypeName(type)).append(".class");
            }
        }
        throw new RuntimeException("invalid constant type: " + this.constType);
    }

    private static String convertStringToJava(String value, boolean ascii) {
        char[] arr = value.toCharArray();
        StringBuilder buffer = new StringBuilder(arr.length);
        block9: for (char c : arr) {
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c < '\u007f' || !ascii && TextUtil.isPrintableUnicode(c)) {
                        buffer.append(c);
                        continue block9;
                    }
                    buffer.append(TextUtil.charToUnicodeLiteral(c));
                }
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ConstExprent)) {
            return false;
        }
        ConstExprent cn = (ConstExprent)o;
        return InterpreterUtil.equalObjects(this.constType, cn.getConstType()) && InterpreterUtil.equalObjects(this.value, cn.getValue());
    }

    public boolean hasBooleanValue() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                int value = (Integer)this.value;
                return value == 0 || DecompilerContext.getOption("bto") && value == 1;
            }
        }
        return false;
    }

    public boolean hasValueOne() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                return (Integer)this.value == 1;
            }
            case 5: {
                return ((Long)this.value).intValue() == 1;
            }
            case 2: {
                return ((Double)this.value).intValue() == 1;
            }
            case 3: {
                return ((Float)this.value).intValue() == 1;
            }
        }
        return false;
    }

    public static ConstExprent getZeroConstant(int type) {
        switch (type) {
            case 4: {
                return new ConstExprent(VarType.VARTYPE_INT, new Integer(0), null);
            }
            case 5: {
                return new ConstExprent(VarType.VARTYPE_LONG, new Long(0L), null);
            }
            case 2: {
                return new ConstExprent(VarType.VARTYPE_DOUBLE, new Double(0.0), null);
            }
            case 3: {
                return new ConstExprent(VarType.VARTYPE_FLOAT, new Float(0.0f), null);
            }
        }
        throw new RuntimeException("Invalid argument: " + type);
    }

    public VarType getConstType() {
        return this.constType;
    }

    public void setConstType(VarType constType) {
        this.constType = constType;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public boolean isBoolPermitted() {
        return this.boolPermitted;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_CONSTTYPE ? !value.value.equals(this.constType) : key == IMatchable.MatchProperties.EXPRENT_CONSTVALUE && value.isVariable() && !engine.checkAndSetVariableValue(value.value.toString(), this.value))) continue;
            return false;
        }
        return true;
    }

    static {
        CHAR_ESCAPES.put(new Integer(8), "\\b");
        CHAR_ESCAPES.put(new Integer(9), "\\t");
        CHAR_ESCAPES.put(new Integer(10), "\\n");
        CHAR_ESCAPES.put(new Integer(12), "\\f");
        CHAR_ESCAPES.put(new Integer(13), "\\r");
        CHAR_ESCAPES.put(new Integer(39), "\\'");
        CHAR_ESCAPES.put(new Integer(92), "\\\\");
    }
}

