/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssFileType;
import icons.StylusIcons;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.StylusBundle;
import org.jetbrains.plugins.stylus.StylusLanguage;

public class StylusFileType
extends LanguageFileType {
    public static final StylusFileType STYLUS = new StylusFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "styl";
    @NonNls
    private static final String NAME = "Stylus";
    @NonNls
    private static final String DESCRIPTION = StylusBundle.message("filetype.description.stylus");

    protected StylusFileType() {
        super((Language)StylusLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/StylusFileType", "getName"));
        }
        return NAME;
    }

    @NotNull
    public String getDescription() {
        String string = DESCRIPTION;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/StylusFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/StylusFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    @Nullable
    public Icon getIcon() {
        return StylusIcons.Styl;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/stylus/StylusFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/stylus/StylusFileType", "getCharset"));
        }
        Charset charset = CssFileType.getCharsetFromCssContent((byte[])content);
        return charset != null ? charset.name() : null;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/stylus/StylusFileType", "extractCharsetFromFileContent"));
        }
        return CssFileType.getCharsetFromCssContent((CharSequence)content);
    }
}

