/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.include;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.include.AbstractCssFileIncludeProvider;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.StylusFileType;
import org.jetbrains.plugins.stylus.StylusLanguage;

public class StylusFileIncludeProvider
extends AbstractCssFileIncludeProvider {
    @NotNull
    public String getId() {
        String string = StylusLanguage.INSTANCE.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "getId"));
        }
        return string;
    }

    public boolean acceptFile(VirtualFile file) {
        return file.isInLocalFileSystem() && file.getFileType() == StylusFileType.STYLUS;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)StylusFileType.STYLUS);
    }

    protected void addImports(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String hostFileExt, @NotNull String importUri, @NotNull String importUriExt) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "addImports"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "addImports"));
        }
        if (hostFileExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFileExt", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "addImports"));
        }
        if (importUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUri", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "addImports"));
        }
        if (importUriExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUriExt", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "addImports"));
        }
        boolean addExtension = !importUriExt.equalsIgnoreCase("css") && !importUriExt.equalsIgnoreCase(hostFileExt);
        result.add(new FileIncludeInfo(addExtension ? importUri + "." + hostFileExt : importUri));
    }

    @NotNull
    protected Language getLanguage() {
        StylusLanguage stylusLanguage = StylusLanguage.INSTANCE;
        if (stylusLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/include/StylusFileIncludeProvider", "getLanguage"));
        }
        return stylusLanguage;
    }
}

