/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.increment;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.psiutil.ExpressionUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSExtractIncrementIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        return this.getText(BinaryOperatorUtils.getOperatorText(JSExtractIncrementIntention.getOperationSign(element)));
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ExtractIncrementPredicate extractIncrementPredicate = new ExtractIncrementPredicate();
        if (extractIncrementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention", "getElementPredicate"));
        }
        return extractIncrementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention", "processIntention"));
        }
        boolean isPostfix = element instanceof JSPostfixExpression;
        JSExpression operand = isPostfix ? ((JSPostfixExpression)element).getExpression() : ((JSPrefixExpression)element).getExpression();
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        assert (statement != null);
        ASTNode statementNode = JSChangeUtil.createStatementFromTextWithContext((Project)element.getProject(), (String)(element.getText() + ';'), (PsiElement)element);
        assert (statementNode != null) : element.getText();
        if (isPostfix) {
            statement.addStatementAfter((JSStatement)statementNode.getPsi());
        } else {
            statement.addStatementBefore((JSStatement)statementNode.getPsi());
        }
        JSElementFactory.replaceExpression((JSExpression)element, operand.getText());
    }

    private static IElementType getOperationSign(PsiElement element) {
        return element instanceof JSPostfixExpression ? ((JSPostfixExpression)element).getOperationSign() : ((JSPrefixExpression)element).getOperationSign();
    }

    private static class ExtractIncrementPredicate
    implements JSElementPredicate {
        private ExtractIncrementPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention$ExtractIncrementPredicate", "satisfiedBy"));
            }
            if (!ExpressionUtil.isIncrementDecrementExpression(element)) {
                return false;
            }
            if (ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSExpressionStatement) {
                return false;
            }
            JSStatement containingStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
            if (element instanceof JSPostfixExpression && (containingStatement instanceof JSReturnStatement || containingStatement instanceof JSThrowStatement)) {
                return false;
            }
            return containingStatement != null;
        }
    }
}

