/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.intentions.JSSplitDeclarationIntention;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitDeclarationAndInitializationIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = JSVariablesWithInitializerPredicate.PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        JSVarStatement varStatement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention", "processIntention"));
        }
        JSVarStatement jSVarStatement = varStatement = element instanceof JSVarStatement ? (JSVarStatement)element : null;
        assert (varStatement != null);
        String varStatementKeyword = varStatement.getVarKeyword().getText();
        String lineTail = JSCodeStyleSettings.getSemicolon((PsiFile)element.getContainingFile()) + "\n";
        PsiFile containingFile = element.getContainingFile();
        StringBuilder declarationBuffer = new StringBuilder();
        for (JSVariable variable : varStatement.getVariables()) {
            String docCommentText;
            JSDocComment docComment = JSSplitDeclarationIntention.getDocComment((JSVariable)variable, (JSVarStatement)varStatement);
            String string = docCommentText = docComment != null ? docComment.getText() : "";
            if (declarationBuffer.length() == 0) {
                declarationBuffer.append(docCommentText);
                if (!StringUtil.isEmpty((String)docCommentText)) {
                    declarationBuffer.append("\n");
                }
                declarationBuffer.append(varStatementKeyword).append(" ");
            } else {
                declarationBuffer.append(",");
                if (!StringUtil.isEmpty((String)docCommentText)) {
                    declarationBuffer.append("\n").append(docCommentText).append("\n");
                }
            }
            declarationBuffer.append(variable.getName());
            String typeString = JSSplitDeclarationAndInitializationIntention.getTypeString(containingFile, (JSInitializerOwner)variable);
            if (typeString == null) continue;
            declarationBuffer.append(":").append(typeString);
        }
        declarationBuffer.append(lineTail);
        ArrayList<String> initializations = new ArrayList<String>();
        JSDestructuringElement destructuringElement = (JSDestructuringElement)PsiTreeUtil.getChildOfType((PsiElement)varStatement, JSDestructuringElement.class);
        if (destructuringElement != null) {
            boolean hasDestructuringArray = PsiTreeUtil.getChildOfType((PsiElement)destructuringElement, JSDestructuringObject.class) != null;
            initializations.add(hasDestructuringArray ? "(" + destructuringElement.getText() + ")" : destructuringElement.getText());
        } else {
            for (JSVariable variable : varStatement.getVariables()) {
                if (variable.getInitializer() == null) continue;
                initializations.add(variable.getName() + '=' + variable.getInitializer().getText() + lineTail);
            }
        }
        this.doReplacement(declarationBuffer.toString(), initializations, varStatement);
    }

    @Nullable
    private static String getTypeString(PsiFile containingFile, @NotNull JSInitializerOwner element) {
        JSType result;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention", "getTypeString"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)element);
        if (dialect == null || !dialect.hasFeature(JSLanguageFeature.TYPES)) {
            return null;
        }
        JSType type = JSPsiImplUtils.getTypeFromDeclaration((JSElement)element);
        if (type != null) {
            return type.getTypeText(JSType.TypeTextFormat.CODE);
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)element);
        if (holder == null) {
            return null;
        }
        JSType jSType = holder.isECMA4 ? JSResolveUtil.getQualifiedExpressionJSType((JSExpression)element.getInitializer(), (PsiFile)containingFile) : (result = element instanceof JSTypeDeclarationOwner ? ((JSTypeDeclarationOwner)element).getType() : JSResolveUtil.getExpressionJSType((JSExpression)element.getInitializer()));
        if (result == null) {
            return null;
        }
        return JSVariablesWithInitializerPredicate.formatType((JSType)result, (PsiElement)element);
    }

    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)oldVarStatement.getContainingFile());
        Project project = oldVarStatement.getProject();
        JSStatement newStatement = (JSStatement)JSChangeUtil.createStatementFromText((Project)project, (String)declarations, (JSLanguageDialect)dialect).getPsi();
        newStatement = oldVarStatement.replace(newStatement);
        int startOffset = newStatement.getTextOffset();
        for (String initialization : initializations) {
            newStatement = newStatement.addStatementAfter((JSStatement)JSChangeUtil.createStatementFromText((Project)project, (String)initialization, (JSLanguageDialect)dialect).getPsi());
        }
        int endOffset = newStatement.getTextOffset() + newStatement.getTextLength();
        CodeStyleManager.getInstance((Project)project).reformatText(newStatement.getContainingFile(), startOffset, endOffset);
    }
}

