/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import org.intellij.idea.lang.javascript.intention.number.JSConvertIntegerIntentionBase;
import org.jetbrains.annotations.NotNull;

public class JSConvertIntegerToBinaryIntention
extends JSConvertIntegerIntentionBase {
    @Override
    @NotNull
    protected String getNumberPrefix(@NotNull JSLiteralExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerToBinaryIntention", "getNumberPrefix"));
        }
        if ("0b" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerToBinaryIntention", "getNumberPrefix"));
        }
        return "0b";
    }

    @Override
    protected int getRadix() {
        return 2;
    }

    @Override
    protected boolean isSatisfy(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerToBinaryIntention", "isSatisfy"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)literalExpression);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.BINARY_AND_OCTAL_LITERALS)) {
            return false;
        }
        return !literalExpression.isBinaryLiteral();
    }
}

