/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;

public class JSMergeElseIfIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MergeElseIfPredicate mergeElseIfPredicate = new MergeElseIfPredicate();
        if (mergeElseIfPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeElseIfIntention", "getElementPredicate"));
        }
        return mergeElseIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeElseIfIntention", "processIntention"));
        }
        JSIfStatement parentStatement = (JSIfStatement)element.getParent();
        assert (parentStatement != null);
        JSBlockStatement elseBranch = (JSBlockStatement)parentStatement.getElse();
        JSStatement elseBranchContents = elseBranch.getStatements()[0];
        JSElementFactory.replaceStatement((JSStatement)elseBranch, (String)elseBranchContents.getText());
    }

    private static class MergeElseIfPredicate
    implements JSElementPredicate {
        private MergeElseIfPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeElseIfIntention$MergeElseIfPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            if (ErrorUtil.containsError((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement thenBranch = ifStatement.getThen();
            JSStatement elseBranch = ifStatement.getElse();
            if (thenBranch == null) {
                return false;
            }
            if (elseBranch == null) {
                return false;
            }
            if (!(elseBranch instanceof JSBlockStatement)) {
                return false;
            }
            JSStatement[] statements = ((JSBlockStatement)elseBranch).getStatements();
            if (statements.length != 1) {
                return false;
            }
            return statements[0] != null && statements[0] instanceof JSIfStatement;
        }
    }
}

