/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.ComparisonUtils;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSElementFactory {
    @NonNls
    private static final String DUMMY_FILE_NAME_PREFIX = "dummy.";
    private static final Class[] WHITESPACE_CLASS = new Class[]{PsiWhiteSpace.class};

    private JSElementFactory() {
    }

    public static PsiElement addElementBefore(@NotNull PsiElement element, @NotNull PsiElement newElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        ASTNode oldElementParentNode = element.getNode();
        PsiElement parentNode = element.getParent();
        ASTNode newElementParentNode = parentNode.getNode();
        ASTNode newElementNode = newElement.getNode();
        if (newElementParentNode == null || newElementNode == null) {
            return null;
        }
        newElementParentNode.addChild(newElementNode, oldElementParentNode);
        return newElement;
    }

    public static PsiElement addElementBefore(@NotNull PsiElement element, @NonNls @NotNull String elementText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        if (elementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementText", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "addElementBefore"));
        }
        PsiElement newElement = JSElementFactory.createDummyFile(element.getProject(), elementText).getFirstChild();
        assert (newElement != null);
        return JSElementFactory.addElementBefore(element, newElement);
    }

    @NotNull
    private static PsiFile createDummyFile(Project project, String text) {
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
        assert (def != null);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(DUMMY_FILE_NAME_PREFIX + JavaScriptSupportLoader.JAVASCRIPT.getDefaultExtension(), text);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "createDummyFile"));
        }
        return psiFile;
    }

    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        ASTNode newExpressionNode = JSChangeUtil.createExpressionFromText((Project)expression.getProject(), (String)text, (JSLanguageDialect)DialectDetector.languageDialectOfElement((PsiElement)expression));
        return newExpressionNode != null ? JSElementFactory.replaceExpression(expression, (JSExpression)newExpressionNode.getPsi()) : expression;
    }

    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NotNull JSExpression newExpression) throws IncorrectOperationException {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpression"));
        }
        ASTNode newExpressionNode = newExpression.getNode();
        ASTNode oldExpressionNode = expression.getNode();
        PsiElement parentNode = expression.getParent();
        ASTNode grandParentNode = parentNode.getNode();
        if (grandParentNode == null || oldExpressionNode == null || newExpressionNode == null) {
            return null;
        }
        grandParentNode.replaceChild(oldExpressionNode, newExpressionNode);
        com.intellij.lang.javascript.psi.JSElementFactory.reformat((PsiElement)parentNode);
        return (JSExpression)newExpressionNode.getPsi();
    }

    public static void replaceExpressionWithNegatedExpression(@NotNull JSExpression newExpression, @NotNull JSExpression exp) throws IncorrectOperationException {
        String replacementString;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpressionWithNegatedExpression"));
        }
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "replaceExpressionWithNegatedExpression"));
        }
        JSExpression expressionToReplace = BoolUtils.findNegation(exp);
        if (expressionToReplace == null) {
            expressionToReplace = exp;
            if (ComparisonUtils.isComparisonOperator(newExpression)) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)newExpression;
                IElementType operationSign = binaryExpression.getOperationSign();
                String negatedComparison = ComparisonUtils.getNegatedOperatorText(operationSign);
                JSExpression leftOperand = binaryExpression.getLOperand();
                JSExpression rightOperand = binaryExpression.getROperand();
                assert (rightOperand != null);
                replacementString = leftOperand.getText() + negatedComparison + rightOperand.getText();
            } else {
                replacementString = '!' + ParenthesesUtils.getParenthesized(newExpression, 3);
            }
        } else {
            replacementString = newExpression.getText();
        }
        JSElementFactory.replaceExpression(expressionToReplace, replacementString);
    }

    public static void replaceExpressionWithNegatedExpressionString(JSExpression exp, String newExpression) throws IncorrectOperationException {
        assert (exp != null);
        JSExpression expressionToReplace = BoolUtils.findNegation(exp);
        String replacementString = newExpression;
        if (expressionToReplace == null) {
            expressionToReplace = exp;
            replacementString = "!(" + newExpression + ')';
        } else {
            PsiElement parent = expressionToReplace.getParent();
            if (parent instanceof JSBinaryExpression && exp instanceof JSBinaryExpression) {
                IElementType parentSign = ((JSBinaryExpression)parent).getOperationSign();
                IElementType childSign = ((JSBinaryExpression)exp).getOperationSign();
                if (childSign == JSTokenTypes.ANDAND && parentSign == JSTokenTypes.ANDAND) {
                    replacementString = "(" + newExpression + ")";
                }
            }
        }
        JSElementFactory.replaceExpression(expressionToReplace, replacementString);
    }

    public static void removeRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "removeRange"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/intellij/idea/lang/javascript/psiutil/JSElementFactory", "removeRange"));
        }
        FormatFixer ff = FormatFixer.create((PsiElement)from, (PsiElement)to, (FormatFixer.Mode)FormatFixer.Mode.FirstLinebreak);
        from.getParent().deleteChildRange(from, to);
        ff.fixFormat();
    }

    public static PsiElement getNonWhiteSpaceSibling(PsiElement element, boolean forward) {
        return forward ? PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])WHITESPACE_CLASS) : PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])WHITESPACE_CLASS);
    }
}

