/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELMethodCallExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.jsp.el.ElLiteralCustomReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolesReferenceProvider
implements ElLiteralCustomReferenceProvider {
    public boolean accept(@NotNull ELLiteralExpression expression) {
        ELVariable invocationMethod;
        ELMethodCallExpression parent;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/security/references/SpringSecurityRolesReferenceProvider", "accept"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression.getContainingFile());
        if (module != null && (parent = (ELMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, ELMethodCallExpression.class)) != null && (invocationMethod = parent.getMethod()) != null) {
            String name = invocationMethod.getName();
            for (PsiMethod method : SecurityExpressionRootMethodsUtil.getExpressionRootMethods(module, SecurityExpressionRootMethodsUtil.getDefaultRootClassName())) {
                if (!method.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull ELLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/security/references/SpringSecurityRolesReferenceProvider", "createReferences"));
        }
        String text = expression.getText();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression.getContainingFile());
        if (module != null && text != null && text.length() > 1) {
            String textValue = text.substring(1, text.length() - 1);
            PsiReference[] psiReferenceArray = new PsiReference[]{new SpringSecurityRolePsiReference((PsiElement)expression, textValue, module, true)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityRolesReferenceProvider", "createReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityRolesReferenceProvider", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

