/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.codehaus.plexus.util.SelectorUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.ext.jee.JavaeeFacetImporter;
import org.jetbrains.idea.maven.ext.jee.OutputFileNameMappingResolver;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class WebFacetImporter
extends JavaeeFacetImporter<WebFacet, WebFacetConfiguration, WebFacetType> {
    @NonNls
    private static final String WAR_PACKAGING = "war";
    private static final String OUTPUT_FILE_NAME_MAPPING = "outputFileNameMapping";
    private static final String DEFAULT_FILE_NAME_MAPPING = "@{artifactId}@-@{version}@.@{extension}@";
    private static final String DEFAULT_FILE_NAME_MAPPING_CLASSIFIER = "@{artifactId}@-@{version}@-@{classifier}@.@{extension}@";

    public WebFacetImporter() {
        super("org.apache.maven.plugins", "maven-war-plugin", WAR_PACKAGING, WebFacetType.getInstance());
    }

    protected String getTargetName(MavenProject p) {
        String warName = this.findConfigValue(p, "warName", super.getTargetName(p));
        String classifier = this.findConfigValue(p, "classifier");
        return StringUtil.isEmpty((String)classifier) ? warName : warName + '-' + classifier;
    }

    @Override
    protected String getExplodedPath(MavenProject p) {
        String result = this.findConfigValue(p, "webappDirectory");
        return result == null ? this.makePath(p, new String[]{p.getBuildDirectory(), p.getFinalName()}) : this.makePath(p, new String[]{result});
    }

    @Override
    protected void setupJavaeeFacet(WebFacet f, MavenProject p) {
    }

    @Override
    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, WebFacet facet, MavenProjectsTree mavenTreel, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        this.reimportWebRoots(facet, mavenProject);
        super.reimportFacet(modelsProvider, module, rootModel, facet, mavenTreel, mavenProject, changes, mavenProjectToModuleName, postTasks);
    }

    @Override
    protected void prepareRootElement(WebFacet facet, CompositePackagingElement<?> rootElement, MavenProject mavenProject) {
        ArtifactUtil.removeChildrenRecursively(rootElement, packagingElement -> !(packagingElement instanceof ProductionModuleOutputPackagingElement) || !facet.getModule().getName().equals(((ProductionModuleOutputPackagingElement)packagingElement).getModuleName()));
        boolean addModule = rootElement.getChildren().isEmpty();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        if (addModule) {
            factory.getOrCreateDirectory(rootElement, ((WebFacetType)this.myFacetType).getDefaultUriForDirectory()).addOrFindChild(factory.createModuleOutput(facet.getModule()));
        } else {
            rootElement.moveChild(1, -1);
        }
        this.prepareArtifactManifest(rootElement, mavenProject);
        rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement((JavaeeFacet)facet));
    }

    @Override
    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? WebArtifactUtil.getInstance().getExplodedWarArtifactType() : WebArtifactUtil.getInstance().getWarArtifactType();
    }

    private void reimportWebRoots(WebFacet facet, MavenProject mavenProject) {
        facet.removeAllWebRoots();
        String webSourceDir = this.getWebRootPath(mavenProject);
        String xmlFile = this.findConfigValue(mavenProject, "webXml");
        xmlFile = xmlFile != null ? this.makePath(mavenProject, new String[]{xmlFile}) : this.makePath(mavenProject, new String[]{webSourceDir, "WEB-INF/web.xml"});
        this.setDescriptor(facet, DeploymentDescriptorsConstants.WEB_XML_META_DATA, xmlFile);
        for (Element each : MavenJDOMUtil.findChildrenByPath((Element)this.getConfig(mavenProject), (String)"webResources", (String)"resource")) {
            String dir = MavenJDOMUtil.findChildValueByPath((Element)each, (String)"directory");
            String targetPath = MavenJDOMUtil.findChildValueByPath((Element)each, (String)"targetPath", (String)"/");
            if (dir == null) continue;
            this.addWebRoot(facet, mavenProject, dir, targetPath);
        }
        this.addWebRoot(facet, mavenProject, webSourceDir);
    }

    private String getWebRootPath(MavenProject mavenProject) {
        return this.findConfigValue(mavenProject, "warSourceDirectory", "src/main/webapp");
    }

    @Override
    @NotNull
    protected String getDescriptorsDirectoryPath(MavenProject mavenProject) {
        String string = this.getWebRootPath(mavenProject);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/WebFacetImporter", "getDescriptorsDirectoryPath"));
        }
        return string;
    }

    private void addWebRoot(WebFacet facet, MavenProject mavenProject, String rootDir) {
        this.addWebRoot(facet, mavenProject, rootDir, "/");
    }

    private void addWebRoot(WebFacet facet, MavenProject mavenProject, String rootDir, String targetPath) {
        String url = VfsUtil.pathToUrl((String)this.makePath(mavenProject, new String[]{rootDir}));
        if (!WebFacetImporter.getExistingWebRootUrls(facet).contains(url)) {
            facet.addWebRootNoFire(url, targetPath);
        }
    }

    private static List<String> getExistingWebRootUrls(WebFacet facet) {
        ArrayList<String> result = new ArrayList<String>();
        for (WebRoot each : facet.getWebRoots()) {
            result.add(each.getDirectoryUrl());
        }
        return result;
    }

    @Override
    protected void setSourceRoots(WebFacet f, String[] urls) {
        f.setWebSourceRoots(urls);
    }

    @Override
    protected List<MavenArtifact> getOrderedDependenciesToPackage(MavenProject mavenProject) {
        List<MavenArtifact> deps = super.getOrderedDependenciesToPackage(mavenProject);
        List<JavaeeFacetImporter.ArtifactConfig> confs = this.getArtifactConfigs(mavenProject, "overlays", "overlay");
        Collections.sort(deps, (o1, o2) -> {
            JavaeeFacetImporter.ArtifactConfig c1 = this.findConfigElementForArtifact((MavenArtifact)o1, confs);
            JavaeeFacetImporter.ArtifactConfig c2 = this.findConfigElementForArtifact((MavenArtifact)o2, confs);
            int i1 = confs.indexOf(c1);
            int i2 = confs.indexOf(c2);
            if (i1 == -1 && i2 == -1) {
                return deps.indexOf(o1) - deps.indexOf(o2);
            }
            if (i1 == -1) {
                return 1;
            }
            if (i2 == -1) {
                return -1;
            }
            return i1 - i2;
        });
        return deps;
    }

    @Override
    @NotNull
    protected String getJarFileNameForModule(MavenProject mavenProject, MavenArtifact depArtifact, MavenProject depProject) {
        String mapping = this.findConfigValue(mavenProject, OUTPUT_FILE_NAME_MAPPING);
        if (mapping == null) {
            mapping = StringUtil.isEmptyOrSpaces((String)depArtifact.getClassifier()) ? DEFAULT_FILE_NAME_MAPPING : DEFAULT_FILE_NAME_MAPPING_CLASSIFIER;
        }
        String string = OutputFileNameMappingResolver.resolve(mapping, depArtifact);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/WebFacetImporter", "getJarFileNameForModule"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getJarFileNameForLibrary(MavenProject mavenProject, WebFacet facet, MavenArtifact mavenArtifact) {
        String mapping = this.findConfigValue(mavenProject, OUTPUT_FILE_NAME_MAPPING);
        if (mapping == null) {
            String string = super.getJarFileNameForLibrary(mavenProject, facet, mavenArtifact);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/WebFacetImporter", "getJarFileNameForLibrary"));
            }
            return string;
        }
        String string = OutputFileNameMappingResolver.resolve(mapping, mavenArtifact);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/WebFacetImporter", "getJarFileNameForLibrary"));
        }
        return string;
    }

    @Override
    protected boolean addFacetDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, WebFacet facet, final ModifiableArtifact artifact, final Module depModule, MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/WebFacetImporter", "addFacetDependency"));
        }
        if (!WebFacetImporter.isOverlay(depArtifact)) {
            return false;
        }
        this.addOverlay(mavenProject, depArtifact, new AddOverlayTask(){

            @Override
            public void add(MavenProject mavenProject, MavenArtifact depArtifact, OverlaySettings settings) {
                Project project = depModule.getProject();
                ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)project).createPointer(MavenUtil.getArtifactName((String)WebFacetImporter.this.myPackaging, (Module)depModule, (boolean)true));
                PackagingElementFactory.getInstance().getOrCreateDirectory(artifact.getRootElement(), settings.targetPath).addOrFindChild((PackagingElement)new ArtifactPackagingElement(project, pointer));
            }
        });
        return true;
    }

    @Override
    protected void addModuleDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Module depModule, MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/WebFacetImporter", "addModuleDependency"));
        }
        if ("client".equals(depArtifact.getClassifier())) {
            Artifact artifactDep = WebFacetImporter.findEjbClientArtifactDependency(depModule, modelsProvider);
            if (artifactDep != null) {
                PackagingElementFactory factory = PackagingElementFactory.getInstance();
                String relativePath = this.getDependencyPackagingUrl(mavenProject) + '/' + jarFileName;
                if (this.isPackagingExcluded(mavenProject, relativePath)) {
                    return;
                }
                CompositePackagingElement parent = factory.getOrCreateArchive(artifact.getRootElement(), relativePath);
                parent.addOrFindChild(factory.createArtifactElement(artifactDep, depModule.getProject()));
            }
        } else {
            super.addModuleDependency(modelsProvider, mavenProject, artifact, depModule, depArtifact, jarFileName);
        }
    }

    @Override
    protected void doAddModuleDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Module depModule, MavenArtifact depArtifact, String jarFileName, String relativeOutputPath) {
        if (!this.isPackagingExcluded(mavenProject, relativeOutputPath, jarFileName)) {
            super.doAddModuleDependency(modelsProvider, mavenProject, artifact, depModule, depArtifact, jarFileName, relativeOutputPath);
        }
    }

    @Override
    protected void doAddLibraryDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Library depLibrary, String relativeOutputPath, String jarFileName) {
        if (!this.isPackagingExcluded(mavenProject, relativeOutputPath, jarFileName)) {
            super.doAddLibraryDependency(modelsProvider, mavenProject, artifact, depLibrary, relativeOutputPath, jarFileName);
        }
    }

    private boolean isPackagingExcluded(MavenProject mavenProject, String relativePath) {
        String packagingExcludes;
        Element configElement = this.getConfig(mavenProject);
        if (configElement != null && (packagingExcludes = MavenJDOMUtil.findChildValueByPath((Element)configElement, (String)"packagingExcludes")) != null) {
            String path = StringUtil.trimStart((String)relativePath, (String)"/");
            List excludes = StringUtil.split((String)packagingExcludes, (String)",");
            for (String each : excludes) {
                if (!SelectorUtils.matchPath((String)each, (String)path)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPackagingExcluded(MavenProject mavenProject, String relativeOutputPath, String jarFileName) {
        String relativePath = FileUtil.toSystemIndependentName((String)new File(relativeOutputPath, jarFileName).getPath());
        return this.isPackagingExcluded(mavenProject, relativePath);
    }

    @Override
    protected boolean reimportCustomDependencyPackaging(MavenProject mavenProject, final WebFacet facet, MavenArtifact depArtifact, final List<MavenProjectsProcessorTask> postTasks) {
        if (!WebFacetImporter.isOverlay(depArtifact)) {
            return false;
        }
        this.addOverlay(mavenProject, depArtifact, new AddOverlayTask(){

            @Override
            public void add(MavenProject mavenProject, MavenArtifact depArtifact, OverlaySettings settings) {
                new OverlayExtractingTask().addIfNecessary(mavenProject, facet, depArtifact, settings, postTasks);
            }
        });
        return true;
    }

    private static boolean isOverlay(MavenArtifact depArtifact) {
        return WAR_PACKAGING.equals(depArtifact.getType());
    }

    @Override
    protected boolean isLinkViaManifest(MavenProject project) {
        return this.getManifestClasspathPrefix(project) != null;
    }

    @Override
    public String getManifestClasspathPrefix(MavenProject project) {
        String addClasspath = this.findConfigValue(project, "archive.manifest.addClasspath");
        if (!"true".equals(addClasspath)) {
            return null;
        }
        return this.findConfigValue(project, "archive.manifest.classpathPrefix", "/");
    }

    private void addOverlay(MavenProject project, MavenArtifact artifact, AddOverlayTask task) {
        OverlaySettings settings = this.collectSettings(project, artifact);
        if (settings.isSkipped) {
            return;
        }
        task.add(project, artifact, settings);
    }

    private OverlaySettings collectSettings(MavenProject project, MavenArtifact artifact) {
        Element configElement = this.findConfigElementForArtifact(artifact, project, "overlays", "overlay");
        OverlaySettings result = new OverlaySettings();
        result.targetPath = MavenJDOMUtil.findChildValueByPath((Element)configElement, (String)"targetPath", (String)"/");
        result.isSkipped = "true".equals(MavenJDOMUtil.findChildValueByPath((Element)configElement, (String)"skip", (String)"false"));
        List<Pattern> defaultIncludes = this.collectGlobalPatterns(project, "dependentWarIncludes", "**/*");
        List<Pattern> defaultExcludes = this.collectGlobalPatterns(project, "dependentWarExcludes", "META-INF/**");
        result.includes = WebFacetImporter.collectPatterns(configElement, "includes", defaultIncludes);
        result.excludes = WebFacetImporter.collectPatterns(configElement, "excludes", defaultExcludes);
        return result;
    }

    private List<Pattern> collectGlobalPatterns(MavenProject project, String path, String defaultValue) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        String value = this.findConfigValue(project, path, defaultValue);
        for (String each : StringUtil.split((String)value, (String)",")) {
            MavenUtil.collectPattern((String)each, result);
        }
        return result;
    }

    private static List<Pattern> collectPatterns(Element configElement, String elementName, List<Pattern> defaultPatterns) {
        Element element;
        Element element2 = element = configElement == null ? null : configElement.getChild(elementName);
        if (element == null) {
            return defaultPatterns;
        }
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (Element eachElement : element.getChildren(StringUtil.unpluralize((String)elementName))) {
            String value = eachElement.getValue();
            if (value == null) continue;
            MavenUtil.collectPattern((String)value, result);
        }
        return result;
    }

    private static interface AddOverlayTask {
        public void add(MavenProject var1, MavenArtifact var2, OverlaySettings var3);
    }

    private static class OverlaySettings {
        String targetPath;
        boolean isSkipped;
        List<Pattern> includes;
        List<Pattern> excludes;

        private OverlaySettings() {
        }
    }

    private class OverlayExtractingTask
    implements MavenProjectsProcessorTask {
        private static final String OVERLAYS_DIR_NAME = "overlays";
        private MavenProject myMavenProject;
        private MavenArtifact myArtifact;
        private String myRelativePath;
        private OverlaySettings mySettings;
        private File myOutputDir;

        private OverlayExtractingTask() {
        }

        public void addIfNecessary(MavenProject mavenProject, WebFacet facet, MavenArtifact artifact, OverlaySettings settings, List<MavenProjectsProcessorTask> postTasks) {
            if (!artifact.getFile().exists()) {
                return;
            }
            this.myMavenProject = mavenProject;
            this.myArtifact = artifact;
            this.mySettings = settings;
            this.disableFacetsDetection(facet);
            String overlayName = this.myArtifact.getGroupId() + "." + this.myArtifact.getArtifactId() + "-" + this.myArtifact.getVersion();
            this.myRelativePath = "overlays/" + overlayName;
            this.myOutputDir = new File(WebFacetImporter.this.makePath(this.myMavenProject, new String[]{this.myRelativePath}));
            WebFacetImporter.this.addWebRoot(facet, this.myMavenProject, this.myRelativePath, this.mySettings.targetPath);
            if (this.shouldUpdateOverlay(this.myOutputDir, this.mySettings)) {
                postTasks.add(this);
            }
        }

        private void disableFacetsDetection(WebFacet facet) {
            Module module = facet.getModule();
            DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)module.getProject());
            excludesConfiguration.addExcludedUrl(VfsUtil.pathToUrl((String)WebFacetImporter.this.makePath(this.myMavenProject, new String[]{OVERLAYS_DIR_NAME})), null);
        }

        public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator process) throws MavenProcessCanceledException {
            process.setText("Clearing war-overlay content for " + this.myArtifact);
            FileUtil.delete((File)this.myOutputDir);
            this.saveOverlaySettings(this.myOutputDir, this.mySettings);
            this.extractWarContent(project, this.myOutputDir, this.mySettings, process);
            this.scheduleFileRefresh();
        }

        private boolean shouldUpdateOverlay(File overlayDir, OverlaySettings settings) {
            if (!overlayDir.exists()) {
                return true;
            }
            File infoFile = this.makeInfoFile(overlayDir);
            if (!infoFile.exists()) {
                return true;
            }
            try {
                String expectedContent = this.makeInfoFileContent(settings);
                String actualContent = FileUtil.loadFile((File)infoFile);
                return !expectedContent.equals(actualContent);
            }
            catch (IOException e) {
                return true;
            }
        }

        private void saveOverlaySettings(File overlayDir, OverlaySettings settings) {
            File file = this.makeInfoFile(overlayDir);
            String content = this.makeInfoFileContent(settings);
            try {
                FileUtil.delete((File)file);
                FileUtil.writeToFile((File)file, (byte[])content.getBytes());
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }

        private File makeInfoFile(File overlayDir) {
            return new File(overlayDir.getParentFile(), overlayDir.getName() + ".info");
        }

        private String makeInfoFileContent(OverlaySettings settings) {
            String timestamp = String.valueOf(this.myArtifact.getFile().lastModified());
            String includesString = this.makePatternsString(settings.includes);
            String excludesString = this.makePatternsString(settings.excludes);
            return timestamp + "\n" + includesString + "\n" + excludesString;
        }

        private String makePatternsString(List<Pattern> patterns) {
            THashSet set = new THashSet();
            for (Pattern each : patterns) {
                set.add(each.pattern());
            }
            ArrayList list = new ArrayList(set);
            Collections.sort(list);
            return StringUtil.join(list, (String)", ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void extractWarContent(Project project, File outputDir, OverlaySettings settings, MavenProgressIndicator process) throws MavenProcessCanceledException {
            process.setText("Extracting war-overlay content for " + this.myArtifact);
            outputDir.mkdirs();
            try (JarFile jar = new JarFile(this.myArtifact.getFile());){
                Enumeration<JarEntry> entries = jar.entries();
                int size = jar.size();
                int i = 0;
                while (entries.hasMoreElements()) {
                    process.checkCanceled();
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    name = StringUtil.trimEnd((String)name, (String)"/");
                    process.setText2(name);
                    process.setFraction((double)i++ / (double)size);
                    if (!MavenUtil.isIncluded((String)name, settings.includes, settings.excludes)) continue;
                    ZipUtil.extractEntry((ZipEntry)entry, (InputStream)jar.getInputStream(entry), (File)outputDir);
                }
            }
            catch (IOException e) {
                MavenUtil.showError((Project)project, (String)("Cannot extract content of " + this.myArtifact), (Throwable)e);
            }
        }

        private void scheduleFileRefresh() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(true));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myMavenProject == ((OverlayExtractingTask)o).myMavenProject && this.myArtifact.equals((Object)((OverlayExtractingTask)o).myArtifact);
        }

        public int hashCode() {
            return 31 * this.myMavenProject.hashCode() + this.myArtifact.hashCode();
        }
    }
}

