/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformIcons;
import icons.MavenIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

public class MavenElement
implements Navigatable {
    private final MavenArtifactNode myArtifact;
    private final Project myProject;
    private final MavenProject myMavenProject;
    private MavenElement parent;

    public MavenElement(@NotNull Project project, @NotNull MavenProject mavenProject, MavenArtifactNode artifact) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/ext/uml/MavenElement", "<init>"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/ext/uml/MavenElement", "<init>"));
        }
        this.myProject = project;
        this.myMavenProject = mavenProject;
        this.myArtifact = artifact;
    }

    public boolean isProject() {
        return MavenProjectsManager.getInstance((Project)this.myProject).findProject(this.getMavenId()) != null;
    }

    public String getName() {
        return this.getMavenId().getArtifactId();
    }

    public List<MavenElement> getChildren() {
        List nodes = this.myArtifact != null ? this.myArtifact.getDependencies() : this.myMavenProject.getDependencyTree();
        ArrayList<MavenElement> children = new ArrayList<MavenElement>(nodes.size());
        MavenProject mavenProject = this.getMavenProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)this.myProject);
        for (MavenArtifactNode node : nodes) {
            MavenProject pr = manager.findProject(node.getArtifact());
            MavenElement mavenElement = new MavenElement(this.myProject, pr == null ? mavenProject : pr, node);
            mavenElement.setParent(this);
            children.add(mavenElement);
        }
        return children;
    }

    public String getDescription() {
        MavenId id = this.getMavenId();
        return "<html>Group ID: <b>" + id.getGroupId() + "</b><br/>Artifact ID: <b>" + id.getArtifactId() + "</b><br/>Version: <b>" + id.getVersion() + "</b></html>";
    }

    @Nullable
    public MavenArtifactScope getScope() {
        return this.myArtifact == null ? null : MavenArtifactScope.fromString((String)this.myArtifact.getArtifact().getScope());
    }

    public String getId() {
        return this.myArtifact == null ? this.myMavenProject.getMavenId().getKey() : MavenElement.id(this.myArtifact);
    }

    public MavenId getMavenId() {
        return this.myArtifact == null ? this.myMavenProject.getMavenId() : this.myArtifact.getArtifact().getMavenId();
    }

    public Icon getIcon() {
        return this.isProject() ? MavenIcons.MavenProject : PlatformIcons.LIBRARY_ICON;
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = this.getNavigatable();
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myMavenProject.getFile();
    }

    public Project getProject() {
        return this.myProject;
    }

    private static String id(MavenArtifactNode node) {
        MavenArtifactNode parent = node.getParent();
        String id = node.getArtifact().getDisplayStringWithTypeAndClassifier();
        return parent == null ? id : MavenElement.id(parent) + "/" + id;
    }

    @Nullable
    public MavenArtifactState getState() {
        return this.myArtifact == null ? null : this.myArtifact.getState();
    }

    public MavenArtifactNode getArtifact() {
        return this.myArtifact;
    }

    public Color getTitleColor() {
        if (this.isProject()) {
            return DiagramColorManagerBase.GENERALIZATION;
        }
        if (this.hasConflicts()) {
            return JBColor.RED;
        }
        if (this.isTestArtifact()) {
            return DiagramColorManagerBase.REALIZATION;
        }
        return Color.BLACK;
    }

    private boolean hasConflicts() {
        return this.myArtifact == null ? false : this.myArtifact.getState() == MavenArtifactState.CONFLICT;
    }

    public boolean isTestArtifact() {
        return this.myArtifact == null ? false : MavenArtifactScope.fromString((String)this.myArtifact.getArtifact().getScope()) == MavenArtifactScope.TEST;
    }

    public MavenProject getMavenProject() {
        MavenProject project = MavenProjectsManager.getInstance((Project)this.myProject).findProject(this.getMavenId());
        return project == null ? this.myMavenProject : project;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (this.isProject()) {
            return MavenNavigationUtil.createNavigatableForPom((Project)this.getProject(), (VirtualFile)this.getMavenProject().getFile());
        }
        MavenElement p = this.getParent();
        VirtualFile file = p == null ? this.getVirtualFile() : (p.isProject() ? p.getVirtualFile() : MavenNavigationUtil.getArtifactFile((Project)this.getProject(), (MavenId)p.getMavenId()));
        return file == null ? null : MavenNavigationUtil.createNavigatableForDependency((Project)this.getProject(), (VirtualFile)file, (MavenArtifact)this.getArtifact().getArtifact());
    }

    public String toString() {
        return this.getName();
    }

    public MavenElement getParent() {
        return this.parent;
    }

    public void setParent(MavenElement parent) {
        this.parent = parent;
    }
}

