/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view.tool;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.server.JavaeeServerDeployExtension;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.view.ServersBundle;
import com.intellij.javaee.view.ServersConfigManager;
import com.intellij.javaee.view.tool.AppServerNode;
import com.intellij.javaee.view.tool.ServersTreeTextAttributes;
import com.intellij.javaee.view.tool.action.DeploymentWorker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.ui.RowIcon;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactNode
extends AbstractTreeNode<Object>
implements DeploymentNode {
    private final String myDeploymentName;
    private final DeploymentModel myDeploymentModel;
    private Boolean myStarted;
    private DeploymentStatus myDeploymentStatus;
    private Project myProject;

    public ArtifactNode(@NotNull Project project, @NotNull String deploymentName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/view/tool/ArtifactNode", "<init>"));
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/javaee/view/tool/ArtifactNode", "<init>"));
        }
        super(project, (Object)deploymentName);
        this.myProject = project;
        this.myDeploymentName = deploymentName;
        this.myDeploymentModel = null;
    }

    public ArtifactNode(@NotNull Project project, @NotNull String deploymentName, @NotNull DeploymentModel deploymentModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/view/tool/ArtifactNode", "<init>"));
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/javaee/view/tool/ArtifactNode", "<init>"));
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/view/tool/ArtifactNode", "<init>"));
        }
        super(project, (Object)deploymentModel);
        this.myProject = project;
        this.myDeploymentName = deploymentName;
        this.myDeploymentModel = deploymentModel;
    }

    public ArtifactNode(@NotNull Project project, @NotNull DeploymentModel deploymentModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/view/tool/ArtifactNode", "<init>"));
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/view/tool/ArtifactNode", "<init>"));
        }
        super(project, (Object)deploymentModel);
        this.myProject = project;
        this.myDeploymentName = null;
        this.myDeploymentModel = deploymentModel;
    }

    public void setStarted(boolean started) {
        this.myStarted = started;
    }

    public String getDeploymentName() {
        return this.myDeploymentName;
    }

    public DeploymentModel getDeploymentModel() {
        return this.myDeploymentModel;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactNode", "getChildren"));
        }
        return list;
    }

    @NotNull
    public ServerNode getServerNode() {
        AppServerNode appServerNode = this.getServer();
        if (appServerNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactNode", "getServerNode"));
        }
        return appServerNode;
    }

    public boolean isDeployActionVisible() {
        return true;
    }

    public boolean isDeployActionEnabled() {
        return this.getServer().isConnected() && this.myDeploymentModel != null && this.myDeploymentModel.isValid();
    }

    public void deploy() {
        DeploymentWorker worker = new DeploymentWorker(this.myProject);
        if (this.myDeploymentModel != null) {
            AppServerNode server = this.getServer();
            J2EEServerInstance serverInstance = this.getServerConfigManager().getServerInstance((CommonModel)server.getCommonStrategy());
            if (serverInstance != null) {
                worker.addDeploymentItem(serverInstance, this.myDeploymentModel);
                worker.compileAndDeploy();
            }
        }
    }

    public boolean isUndeployActionEnabled() {
        return this.getServer().isConnected() && (this.getDeploymentStatus() == DeploymentStatus.DEPLOYED || this.getDeploymentStatus() == DeploymentStatus.PREPARED);
    }

    public void undeploy() {
        ServersConfigManager manager = this.getServerConfigManager();
        if (this.myDeploymentModel != null) {
            AppServerNode server = this.getServer();
            J2EEServerInstance serverInstance = manager.getServerInstance((CommonModel)server.getCommonStrategy());
            if (serverInstance != null) {
                server.getCommonStrategy().getDeploymentProvider().startUndeploy(serverInstance, this.myDeploymentModel);
            }
        } else {
            this.performDeploymentAction(manager, extension -> extension.undeploy(this.getDeploymentName()));
        }
    }

    public void performDeploymentAction(ServersConfigManager manager, Consumer<JavaeeServerDeployExtension> runnable) {
        CommonStrategy server = this.getServer().getCommonStrategy();
        JavaeeServerDeployExtension serverExtension = manager.getServerExtension((CommonModel)server);
        if (serverExtension != null) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                runnable.accept(serverExtension);
                ApplicationManager.getApplication().invokeLater(() -> manager.updateDeployments(server));
            });
        }
    }

    public boolean isDebugActionVisible() {
        return false;
    }

    public void deployWithDebug() {
    }

    public boolean isDeployed() {
        return this.myDeploymentStatus == DeploymentStatus.DEPLOYED;
    }

    private ServersConfigManager getServerConfigManager() {
        return ServersConfigManager.getInstance(this.myProject);
    }

    public AppServerNode getServer() {
        return (AppServerNode)this.getParent();
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.myDeploymentStatus;
    }

    protected void update(PresentationData presentation) {
        TextAttributesKey textAttributesKey;
        Icon deploymentIcon;
        String text;
        DeploymentStatus immediateDeploymentStatus;
        DeploymentStatus deploymentStatus = this.myStarted == null ? DeploymentStatus.NOT_DEPLOYED : (immediateDeploymentStatus = this.myStarted != false ? DeploymentStatus.DEPLOYED : DeploymentStatus.PREPARED);
        if (this.myDeploymentModel == null) {
            this.myDeploymentStatus = immediateDeploymentStatus;
            text = ServersBundle.message("ServersTreeStructure.node.artifact", this.myDeploymentName);
            deploymentIcon = AllIcons.Nodes.Artifact;
            textAttributesKey = ServersTreeTextAttributes.NON_IDEA_DEPLOYMENT;
        } else {
            CommonStrategy server = this.getServer().getCommonStrategy();
            DeploymentStatus managedDeploymentStatus = DeploymentManagerEx.getInstanceEx((Project)this.myProject).getDeploymentStatus(this.myDeploymentModel, (CommonModel)server);
            this.myDeploymentStatus = managedDeploymentStatus == DeploymentStatus.ACTIVATING || managedDeploymentStatus == DeploymentStatus.DISCONNECTED ? managedDeploymentStatus : (immediateDeploymentStatus == DeploymentStatus.DEPLOYED ? immediateDeploymentStatus : (managedDeploymentStatus == DeploymentStatus.FAILED ? managedDeploymentStatus : (immediateDeploymentStatus == DeploymentStatus.PREPARED ? immediateDeploymentStatus : managedDeploymentStatus)));
            if (!this.myDeploymentModel.isValid()) {
                presentation.setIcon(UIUtil.getBalloonErrorIcon());
                presentation.setPresentableText(ServersBundle.message("ServersTreeStructure.node.artifact.invalid", new Object[0]));
                return;
            }
            String presentableName = this.myDeploymentModel.getDeploymentSource().getPresentableName();
            if (this.myDeploymentStatus == DeploymentStatus.DEPLOYED) {
                boolean synced = this.getServerConfigManager().getArtifactSyncTracker().isArtifactSynced(server, this.myDeploymentModel.getArtifact());
                String syncedMessage = ServersBundle.message(synced ? "ServersTreeStructure.node.artifact.synced" : "ServersTreeStructure.node.artifact.unsynced", new Object[0]);
                text = ServersBundle.message("ServersTreeStructure.node.artifact.deployed", presentableName, syncedMessage);
            } else {
                text = ServersBundle.message("ServersTreeStructure.node.artifact", presentableName);
            }
            deploymentIcon = this.myDeploymentModel.getDeploymentSource().getIcon();
            textAttributesKey = ServersTreeTextAttributes.IDEA_DEPLOYMENT;
        }
        presentation.setPresentableText(text);
        presentation.setAttributesKey(textAttributesKey);
        RowIcon icon = new RowIcon(2);
        icon.setIcon(deploymentIcon, 0);
        Icon statusIcon = this.myDeploymentStatus == DeploymentStatus.PREPARED ? AllIcons.RunConfigurations.TestPaused : this.myDeploymentStatus.getIcon(null);
        icon.setIcon(statusIcon, 1);
        presentation.setIcon((Icon)icon);
    }
}

