/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.execution.DefaultOutputProcessor;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.HashSet;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinDeploymentProvider;
import org.intellij.j2ee.web.resin.ResinModelDataBase;
import org.intellij.j2ee.web.resin.ResinModuleDeploymentModel;
import org.intellij.j2ee.web.resin.ResinServerInstance;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.ResinPersistentDataHelper;
import org.intellij.j2ee.web.resin.resin.configuration.JmxConfigurationStrategy;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResinModelBase<D extends ResinModelDataBase>
implements ServerModel {
    private D myData = this.createResinModelData();
    private CommonModel myCommonModel;

    public final int getDefaultPort() {
        return 80;
    }

    public final void setCommonModel(CommonModel commonModel) {
        this.myCommonModel = commonModel;
    }

    public final CommonModel getCommonModel() {
        return this.myCommonModel;
    }

    public final J2EEServerInstance createServerInstance() throws ExecutionException {
        return new ResinServerInstance(this.myCommonModel);
    }

    public final DeploymentProvider getDeploymentProvider() {
        return new ResinDeploymentProvider();
    }

    @NotNull
    public final String getDefaultUrlForBrowser() {
        ApplicationServerUrlMapping urlMapping = (ApplicationServerUrlMapping)this.myCommonModel.getIntegration().getDeployedFileUrlProvider();
        String string = urlMapping.getDefaultUrlForServerConfig(this.myCommonModel);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/ResinModelBase", "getDefaultUrlForBrowser"));
        }
        return string;
    }

    public final OutputProcessor createOutputProcessor(ProcessHandler processHandler, J2EEServerInstance j2EEServerInstance) {
        return new DefaultOutputProcessor(processHandler);
    }

    public final Project getProject() {
        return this.myCommonModel.getProject();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected final D getData() {
        return this.myData;
    }

    public int getLocalPort() {
        return ((ResinModelDataBase)this.getData()).getPort();
    }

    public int getPort() {
        return ((ResinModelDataBase)this.getData()).getPort();
    }

    public void setPort(int port) {
        ((ResinModelDataBase)this.getData()).setPort(port);
    }

    public int getJmxPort() {
        return ((ResinModelDataBase)this.getData()).getJmxPort();
    }

    public void setJmxPort(int jmxPort) {
        ((ResinModelDataBase)this.getData()).setJmxPort(jmxPort);
    }

    public String getCharset() {
        String charset = ((ResinModelDataBase)this.getData()).getCharset();
        return charset == null ? "" : charset.trim();
    }

    public void setCharset(String charset) {
        ((ResinModelDataBase)this.getData()).setCharset(charset);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        HashSet<String> contexts = new HashSet<String>();
        for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
            ResinModuleDeploymentModel model = (ResinModuleDeploymentModel)deploymentModel;
            String contextPath = model.getContextPath();
            if (model.isDefaultContextPath() || contexts.add(contextPath)) continue;
            throw new RuntimeConfigurationError(ResinBundle.message("error.duplicate.context.path.text", contextPath));
        }
    }

    public final void readExternal(Element element) throws InvalidDataException {
        D data = this.createResinModelData();
        XmlSerializer.deserializeInto(data, (Element)element);
        this.myData = data;
    }

    public final void writeExternal(Element element) throws WriteExternalException {
        XmlSerializer.serializeInto(this.myData, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public ResinPersistentDataHelper getHelper() {
        return new ResinPersistentDataHelper(this.getCommonModel().getApplicationServer());
    }

    @Nullable
    public ResinInstallation getInstallation() {
        return this.getHelper().getInstallation();
    }

    @Nullable
    public JmxConfigurationStrategy getJmxStrategy() {
        return this.getHelper().getJmxStrategy();
    }

    public boolean hasJmxStrategy() {
        return this.getHelper().hasJmxStrategy();
    }

    protected abstract D createResinModelData();

    public abstract boolean transferFile(File var1);

    public abstract boolean deleteFile(File var1);

    @Nullable
    public abstract SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel var1, DeploymentSource var2);
}

