/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.intellij.j2ee.web.resin.ResinModel;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.configuration.Resin31ConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.ResinConfigImport;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class ResinXmlConfigurationStrategy
extends Resin31ConfigurationStrategy {
    private static final Logger LOG = Logger.getInstance((String)("#" + ResinXmlConfigurationStrategy.class.getName()));
    @NonNls
    public static final String IMPORT_SINGLE_PATH_ATTRIBUTE = "path";
    @NonNls
    private static String[] IMPORT_ATTRIBUTE_NAMES = new String[]{"path", "fileset"};
    @NonNls
    private static final String CONF_FOLDER_VAR = "${__DIR__}";
    @NonNls
    protected static final String RESIN_CONF = "resin32.xml";
    private List<ResinConfigImport> myImports;

    ResinXmlConfigurationStrategy(ResinInstallation resinInstallation) {
        super(resinInstallation);
    }

    @Override
    public void init(ResinModel serverModel, Document document) throws ExecutionException {
        super.init(serverModel, document);
        this.myImports = new ArrayList<ResinConfigImport>();
        this.resolveImports(document, this.myImports);
    }

    @Override
    public InputStream getDefaultResinConfContent() {
        return this.getClass().getResourceAsStream(RESIN_CONF);
    }

    protected void resolveImports(Document document, @Nullable List<ResinConfigImport> imports) {
        try {
            File confFolder = new File(this.getInstallation().getResinHome(), "conf");
            String confFolderPath = FileUtil.toSystemIndependentName((String)confFolder.getAbsolutePath());
            for (String importAttrName : IMPORT_ATTRIBUTE_NAMES) {
                XPath xpath = XPath.newInstance((String)("//*[name()='resin:import' or name()='resin:properties'][@" + importAttrName + "]"));
                List elements = xpath.selectNodes((Object)document);
                for (Element element : elements) {
                    String path = element.getAttributeValue(importAttrName);
                    element.setAttribute(importAttrName, StringUtil.replace((String)path, (String)CONF_FOLDER_VAR, (String)confFolderPath));
                    if (imports == null || !StringUtil.equals((CharSequence)IMPORT_SINGLE_PATH_ATTRIBUTE, (CharSequence)importAttrName)) continue;
                    imports.add(new ResinConfigImport(element));
                }
            }
        }
        catch (JDOMException ex) {
            LOG.info((Throwable)ex);
        }
    }

    protected final List<ResinConfigImport> getImports() {
        return this.myImports;
    }

    @Override
    public void save() throws ExecutionException {
        for (ResinConfigImport configImport : this.getImports()) {
            configImport.save();
        }
    }
}

