/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Keyframe;
import android.animation.Keyframes;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PointF;
import java.util.ArrayList;

public class PathKeyframes
implements Keyframes {
    private static final int FRACTION_OFFSET = 0;
    private static final int X_OFFSET = 1;
    private static final int Y_OFFSET = 2;
    private static final int NUM_COMPONENTS = 3;
    private static final ArrayList<Keyframe> EMPTY_KEYFRAMES = new ArrayList();
    private PointF mTempPointF = new PointF();
    private float[] mKeyframeData;

    public PathKeyframes(Path path) {
        this(path, 0.5f);
    }

    public PathKeyframes(Path path, float error) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("The path must not be null or empty");
        }
        this.mKeyframeData = path.approximate(error);
    }

    public ArrayList<Keyframe> getKeyframes() {
        return EMPTY_KEYFRAMES;
    }

    @Override
    public Object getValue(float fraction2) {
        int numPoints = this.mKeyframeData.length / 3;
        if (fraction2 < 0.0f) {
            return this.interpolateInRange(fraction2, 0, 1);
        }
        if (fraction2 > 1.0f) {
            return this.interpolateInRange(fraction2, numPoints - 2, numPoints - 1);
        }
        if (fraction2 == 0.0f) {
            return this.pointForIndex(0);
        }
        if (fraction2 == 1.0f) {
            return this.pointForIndex(numPoints - 1);
        }
        int low = 0;
        int high = numPoints - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            float midFraction = this.mKeyframeData[mid * 3 + 0];
            if (fraction2 < midFraction) {
                high = mid - 1;
                continue;
            }
            if (fraction2 > midFraction) {
                low = mid + 1;
                continue;
            }
            return this.pointForIndex(mid);
        }
        return this.interpolateInRange(fraction2, high, low);
    }

    private PointF interpolateInRange(float fraction2, int startIndex, int endIndex) {
        int startBase = startIndex * 3;
        int endBase = endIndex * 3;
        float startFraction = this.mKeyframeData[startBase + 0];
        float endFraction = this.mKeyframeData[endBase + 0];
        float intervalFraction = (fraction2 - startFraction) / (endFraction - startFraction);
        float startX = this.mKeyframeData[startBase + 1];
        float endX = this.mKeyframeData[endBase + 1];
        float startY = this.mKeyframeData[startBase + 2];
        float endY = this.mKeyframeData[endBase + 2];
        float x = PathKeyframes.interpolate(intervalFraction, startX, endX);
        float y = PathKeyframes.interpolate(intervalFraction, startY, endY);
        this.mTempPointF.set(x, y);
        return this.mTempPointF;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void setEvaluator(TypeEvaluator evaluator) {
    }

    @Override
    public Class getType() {
        return PointF.class;
    }

    @Override
    public Keyframes clone() {
        Keyframes clone = null;
        try {
            clone = (Keyframes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private PointF pointForIndex(int index) {
        int base = index * 3;
        int xOffset = base + 1;
        int yOffset = base + 2;
        this.mTempPointF.set(this.mKeyframeData[xOffset], this.mKeyframeData[yOffset]);
        return this.mTempPointF;
    }

    private static float interpolate(float fraction2, float startValue, float endValue) {
        float diff = endValue - startValue;
        return startValue + diff * fraction2;
    }

    public Keyframes.FloatKeyframes createXFloatKeyframes() {
        return new FloatKeyframesBase(){

            @Override
            public float getFloatValue(float fraction2) {
                PointF pointF = (PointF)PathKeyframes.this.getValue(fraction2);
                return pointF.x;
            }
        };
    }

    public Keyframes.FloatKeyframes createYFloatKeyframes() {
        return new FloatKeyframesBase(){

            @Override
            public float getFloatValue(float fraction2) {
                PointF pointF = (PointF)PathKeyframes.this.getValue(fraction2);
                return pointF.y;
            }
        };
    }

    public Keyframes.IntKeyframes createXIntKeyframes() {
        return new IntKeyframesBase(){

            @Override
            public int getIntValue(float fraction2) {
                PointF pointF = (PointF)PathKeyframes.this.getValue(fraction2);
                return Math.round(pointF.x);
            }
        };
    }

    public Keyframes.IntKeyframes createYIntKeyframes() {
        return new IntKeyframesBase(){

            @Override
            public int getIntValue(float fraction2) {
                PointF pointF = (PointF)PathKeyframes.this.getValue(fraction2);
                return Math.round(pointF.y);
            }
        };
    }

    static abstract class FloatKeyframesBase
    extends SimpleKeyframes
    implements Keyframes.FloatKeyframes {
        FloatKeyframesBase() {
        }

        @Override
        public Class getType() {
            return Float.class;
        }

        @Override
        public Object getValue(float fraction2) {
            return Float.valueOf(this.getFloatValue(fraction2));
        }
    }

    static abstract class IntKeyframesBase
    extends SimpleKeyframes
    implements Keyframes.IntKeyframes {
        IntKeyframesBase() {
        }

        @Override
        public Class getType() {
            return Integer.class;
        }

        @Override
        public Object getValue(float fraction2) {
            return this.getIntValue(fraction2);
        }
    }

    private static abstract class SimpleKeyframes
    implements Keyframes {
        private SimpleKeyframes() {
        }

        @Override
        public void setEvaluator(TypeEvaluator evaluator) {
        }

        @Override
        public void invalidateCache() {
        }

        public ArrayList<Keyframe> getKeyframes() {
            return EMPTY_KEYFRAMES;
        }

        @Override
        public Keyframes clone() {
            Keyframes clone = null;
            try {
                clone = (Keyframes)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return clone;
        }
    }
}

